<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dialogflow;

class GoogleCloudDialogflowV2ConversationEvent extends \Google\Model
{
  public const TYPE_TYPE_UNSPECIFIED = 'TYPE_UNSPECIFIED';
  public const TYPE_CONVERSATION_STARTED = 'CONVERSATION_STARTED';
  public const TYPE_CONVERSATION_FINISHED = 'CONVERSATION_FINISHED';
  public const TYPE_HUMAN_INTERVENTION_NEEDED = 'HUMAN_INTERVENTION_NEEDED';
  public const TYPE_NEW_MESSAGE = 'NEW_MESSAGE';
  public const TYPE_NEW_RECOGNITION_RESULT = 'NEW_RECOGNITION_RESULT';
  public const TYPE_UNRECOVERABLE_ERROR = 'UNRECOVERABLE_ERROR';
  /**
   * @var string
   */
  public $conversation;
  protected $errorStatusType = GoogleRpcStatus::class;
  protected $errorStatusDataType = '';
  protected $newMessagePayloadType = GoogleCloudDialogflowV2Message::class;
  protected $newMessagePayloadDataType = '';
  protected $newRecognitionResultPayloadType = GoogleCloudDialogflowV2StreamingRecognitionResult::class;
  protected $newRecognitionResultPayloadDataType = '';
  /**
   * @var string
   */
  public $type;

  /**
   * @param string $conversation
   */
  public function setConversation($conversation)
  {
    $this->conversation = $conversation;
  }
  /**
   * @return string
   */
  public function getConversation()
  {
    return $this->conversation;
  }
  /**
   * @param GoogleRpcStatus $errorStatus
   */
  public function setErrorStatus(GoogleRpcStatus $errorStatus)
  {
    $this->errorStatus = $errorStatus;
  }
  /**
   * @return GoogleRpcStatus
   */
  public function getErrorStatus()
  {
    return $this->errorStatus;
  }
  /**
   * @param GoogleCloudDialogflowV2Message $newMessagePayload
   */
  public function setNewMessagePayload(GoogleCloudDialogflowV2Message $newMessagePayload)
  {
    $this->newMessagePayload = $newMessagePayload;
  }
  /**
   * @return GoogleCloudDialogflowV2Message
   */
  public function getNewMessagePayload()
  {
    return $this->newMessagePayload;
  }
  /**
   * @param GoogleCloudDialogflowV2StreamingRecognitionResult $newRecognitionResultPayload
   */
  public function setNewRecognitionResultPayload(GoogleCloudDialogflowV2StreamingRecognitionResult $newRecognitionResultPayload)
  {
    $this->newRecognitionResultPayload = $newRecognitionResultPayload;
  }
  /**
   * @return GoogleCloudDialogflowV2StreamingRecognitionResult
   */
  public function getNewRecognitionResultPayload()
  {
    return $this->newRecognitionResultPayload;
  }
  /**
   * @param self::TYPE_* $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return self::TYPE_*
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDialogflowV2ConversationEvent::class, 'Google_Service_Dialogflow_GoogleCloudDialogflowV2ConversationEvent');
