<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;

use App\Models\Plan;
use App\Models\Slide;
use App\Models\Role;
use App\Models\Language;
use App\Models\MealPicture;
use App\Models\ExerciseVideoCategory;
use App\Models\ExerciseVideos;
use App\Models\ConsultationQuery;
use App\Models\CallRequest;
use App\Models\Entry;
use App\Models\FormBuilderUpload;
use App\Models\FormBuilderWorkout;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Auth;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Exception;
use PhpOffice\PhpSpreadsheet\Writer\Xls;
use PhpOffice\PhpSpreadsheet\IOFactory;
use Illuminate\Support\Facades\Crypt;

use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Support\Facades\Auth as FacadesAuth;
use Illuminate\Support\Facades\DB;

class LoginController extends Controller
{

    public function login()
    {
        if(!empty(FacadesAuth::user())){
            return redirect(route('dashboard'));
        }

        return view('login');
    }

    public function doLogin(Request $request)
    {
        $isExist = User::where("email",$request->email)->first();
        if(empty($isExist)){
            return redirect()->back()->with('error','Invalid Email');
        }
        if (!Hash::check($request->password, $isExist->password))
        {
            return redirect()->back()->with('error','Password Not Match');
        }
        if($isExist->role=="appuser"){
            return redirect()->back()->with('error','Registred as a Application user');
        }
        if($isExist->status==0){
            return redirect()->back()->with('error','Unauthorized for login');
        }
        $userdata = array(
            'email' => $request->email,
            'password' => $request->password
        );
        // attempt to do the login
        if (FacadesAuth::attempt($userdata))
        {
            $authUser = FacadesAuth::user();
            $role = Role::where('name',$authUser->role)->first();
           
            if(empty($role)){
                return redirect()->back()->with('error','Something went wrong!');
            }
           
            if($role->status==0){
                FacadesAuth::logout();
                return redirect()->back()->with('error','Unauthorized for login');
            }
           
            return redirect(route("dashboard"))->with("success","Welcome");
        }
        else
        {
            return redirect(route("login"))->with("error","Something went wrong!");
        }
        return $isExist;
    }

    public function dashboard()
    {
        $sts = [
            'admin_users'=>User::whereIn('role',['admin','user','subadmin'])->count(),
            'app_users'=>User::where('role','appuser')->count(),
            'free_users'=>User::where('role','appuser')->where('is_subscription',0)->count(),
            'paid_users'=>User::where('role','appuser')->where('is_subscription',1)->count(),

            'exercise_videos'=>ExerciseVideos::where('status',1)->count(),
            'consultation_query'=>ConsultationQuery::where('status',0)->count(),
            'call_request'=>CallRequest::where('status',1)->count(),
            'meal_picture'=>MealPicture::where("is_active",1)->where("is_approved",0)->count(),
        ];
        return view('dashboard',compact('sts'));
    }

    public function logout()
    {
        FacadesAuth::logout();
        return redirect(route("login"));
    }

    public function showEntriesForm()
        {
            return view('test.form');
        }

    public function createEntriesForm(Request $request)
        {
            $accountInfo = array();//Later

            $start_balance = $request->opening_balance;//34248.06;
            $end_balance = $request->closing_balance;
            $start_date = date('Y-m-d',strtotime($request->start_date));
            $end_date = date('Y-m-d',strtotime($request->end_date));
           
            $no_of_credit_entries = $request->no_entries;;
            $no_of_withdrawal_entry = $no_of_credit_entries*2;
            $no_of_vendor_entries = $no_of_credit_entries*2;
            $no_of_entries = $no_of_withdrawal_entry+$no_of_credit_entries+$no_of_vendor_entries;
            $is_add_stamp = false;
            $stamp_image = "";

            $estimate_atleast_credit_per_trans = $end_balance/round($no_of_credit_entries/1.2);
            $account_list = array(
                array("account_type"=>"P2M","account_number"=>12345,"bank_name"=>"PUNJAB NATIONAL BANK","account_holder"=>"GURJANT SINGH S O"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"PUNJAB NATIONAL BANK","account_holder"=>"EKONKAR TRANSPORT COMPANY"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"ICICI BANK LIMITED","account_holder"=>"AMBALA JAGADHARI ROA"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"HDFC BANK","account_holder"=>"A S CARRYING"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"PUNJAB NATIONAL BANK","account_holder"=>"Shamsher Singh"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"DBS BANK","account_holder"=>"NAV DURGA TRADING CO"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"HDFC BANK","account_holder"=>"MADHURA RUBBERS"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"ICICI BANK LIMITED/","account_holder"=>"NEXTBILLION TECHNOLOGY PRIVA")
            );
            $account_list_imps = array(
                array("account_type"=>"P2A","account_number"=>12345,"bank_name"=>"PUNJAB NATIONAL BANK","account_holder"=>"AGIAKARS"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"HDFCBANKLTD","account_holder"=>"HARGOBINDFILLINGSTA"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"UNIONBANKOFINDIA","account_holder"=>"KLARORAANDASSOCIATE"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"YESBANKL","account_holder"=>"SUKHWIND"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"HDFCBANKLTD","account_holder"=>"Shamshersingh"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"PUNJABNATIONALBANK","account_holder"=>"EKONKARTRANSPORTCOM"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"PUNJABNATIONALBANK","account_holder"=>"KrishanKumarGrover"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"STATEBANKOFINDIA","account_holder"=>"Sajdakhatoon"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"STATEBANKOFINDIA","account_holder"=>"aroraenterprises"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"HDFCBANKLTD","account_holder"=>"AgyakarSingh"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"PUNJABNATIONALBANK","account_holder"=>"sidhubrarfilingstat"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"INDUSIND","account_holder"=>"NEETARAN"),
                array("account_type"=>"P2A","account_number"=>78945,"bank_name"=>"AXISBANK","account_holder"=>"Kulwinder")
            );
            $account_transaction_mod = array(
                "credit","debit"
            );
            $account_transaction_type = array(
                "credit"=>array("NEFT","IMPS","UPI"),
                "debit"=>array("NEFT","UPI","POS")
            );
            $account_transaction_limits = array(
                "credit"=>array( "min"=>10000, "max"=>round($estimate_atleast_credit_per_trans,-4)+($end_balance/$no_of_credit_entries) ),
                "debit"=>array( "min"=>700, "max"=>7000 )
            );
            $mod_of_transction_detail = array(
                "UPI"=>array("P2A","P2M","P2M","P2A","P2M"),
                "POS"=>array("Location"),
                "IMPS"=>array("P2A","P2M"),
                "NEFT"=>array("P2A","P2M"),
                "RTGS"=>array("P2A","P2M")
            );
            $p2m_list = array(
                "UPI"=>array(
                    array("name"=>"GROWW CREDITSERV TECH","bank"=>"YesBank_Yespay"),
                    array("name"=>"BharatPe Merchant","bank"=>"YesBank_Yespay"),
                    array("name"=>"SINGH DAIRY AND SWEET","bank"=>"Yes Bank Ltd"),
                    array("name"=>"MS OM AUTOMOBILES","bank"=>"Paytm Payments Bank"),
                    array("name"=>"billdesktez  ","bank"=>"ICICI Bank"),
                    array("name"=>"NEW DIAMOND FILLING","bank"=>"Yes Bank Ltd"),
                    array("name"=>"JAGJEET SINGH","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Google India Digital","bank"=>"Axis Bank Ltd"),
                    array("name"=>"EURONETGPAY","bank"=>"ICICI Bank"),
                    array("name"=>"RKVK FILLING STATION ","bank"=>"Yes Bank Ltd"),
                    array("name"=>"AMAR ENTERPRISE","bank"=>"Yes Bank Ltd"),
                    array("name"=>"T P D FUEL CENTER","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Airtel","bank"=>"Paytm Payments Bank"),
                    array("name"=>"JAISWAL FILLING STATION","bank"=>"ICICI Bank"),
                    array("name"=>"HP Moran","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Bhadua Super Service","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Dish TVQR","bank"=>"HDFC BANK LTD"),
                    array("name"=>"MOHANBARI PB FUEL STA","bank"=>"Axis Bank Ltd"),
                    array("name"=>"EAST WEST SERVICE CEN","bank"=>"UCO Bank"),
                    array("name"=>"SUNDARAM FINANCE LTD","bank"=>"HSBC"),
                    array("name"=>"MPD 3 PENTA PURE FILLING","bank"=>"Yes Bank Ltd"),
                    array("name"=>"SINGLA STEEL STORE","bank"=>"Canara Bank"),
                    array("name"=>"HLM Fuel Station","bank"=>"Yes Bank Ltd"),
                    array("name"=>"ETC Toll Tag","bank"=>"ICICI Bank"),
                    array("name"=>"BRAR MOTORS","bank"=>"Axis Bank Ltd"),
                    array("name"=>"Euronet Services India","bank"=>"Axis Bank Ltd."),
                    array("name"=>"RKVK FILLING STATION","bank"=>"Yes Bank Ltd"),
                    array("name"=>"HARJINDER SINGH SO ","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Tamkuhiraj Motors","bank"=>"Yes Bank Ltd"),
                    array("name"=>"SIMULTAPU FUEL JUNCTION","bank"=>"Yes Bank Ltd"),
                    array("name"=>"HP Petrol Pump - Vee","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Carry On Burger","bank"=>"Axis Bank Ltd."),
                    array("name"=>"Radha Kishan Filling","bank"=>"Yes Bank Ltd"),
                    array("name"=>"BP Petrol Pump - Nes","bank"=>"Yes Bank Ltd"),
                    array("name"=>"MOGA-SERVICE","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Chaupal T","bank"=>"ICICI Bank"),
                    array("name"=>"HIRA MOTORS","bank"=>"Yes Bank Ltd"),
                    array("name"=>"Jathinder verma","bank"=>"Yes Bank Ltd"),
                    array("name"=>"NAMDEV TYRE","bank"=>"Axis Bank Ltd"),
                    array("name"=>"StellingRailyatr","bank"=>"ICICI Bank"),
                    array("name"=>"Mr VIJAY KUMAR","bank"=>"Yes Bank Ltd"),
                    array("name"=>"PARMINDER SINGH S/O","bank"=>"Yes Bank Ltd"),
                    array("name"=>"KOTAK MAHINDRA LIFE I","bank"=>"Axis Bank Ltd"),
                    
                ),
                "POS"=>array("PETRO JUNCTION","M C ZOOLOGICAL PARK")
            );
            $p2a_list = array(
                array("name"=>"NEETA RANI","bank_name"=>"INDUSIND","ref"=>"NA"),
                array("name"=>"KULWINDER SINGH","bank_name"=>"ICICI Bank","ref"=>"NA"),
                array("name"=>"VISHAL BANSAL","bank_name"=>"ICICI Bank","ref"=>"NO REM"),
                array("name"=>"SANDEEP","bank_name"=>"Kotak Mah","ref"=>"NA"),
                array("name"=>"VISHAL BANSAL","bank_name"=>"Bank of India","ref"=>"NO REM"),
                array("name"=>"MADAN LAL GADRI","bank_name"=>"Bank of Baroda","ref"=>"NO REM"),
                array("name"=>"Raju Kumar","bank_name"=>"State Bank Of India","ref"=>"NO REM"),
                array("name"=>"AGIAKAR Singh","bank_name"=>"Punjab National","ref"=>"na"),
                array("name"=>"AGIAKARS","bank_name"=>"Punjab National","ref"=>"NA"),
                array("name"=>"HARGOBINDFILLINGSTATION","bank_name"=>"HDFCBANKLTD","ref"=>"X655243"),
                array("name"=>"SHAMSHER SINGH","bank_name"=>"ICICI Bank","ref"=>"UPI"),
                array("name"=>"RAJ KUMAR VERMA","bank_name"=>"Punjab National Bank","ref"=>"UPI"),
                array("name"=>"GURPREET SINGH","bank_name"=>"HDFC BANK LTD","ref"=>"UPI"),
                array("name"=>"KLARORAANDASSOCIATE","bank_name"=>"UNIONBANKOFINDIA","ref"=>"X396564"),
                array("name"=>"VIKAS ENTERPRISES PRO","bank_name"=>"Punjab and Sind Bank","ref"=>"UPI"),
                array("name"=>"AMARJIT KAUR WO SUBA","bank_name"=>"Bank of India","ref"=>"UPI"),
                array("name"=>"S ZORA SINGH AND SONS","bank_name"=>"State Bank Of India","ref"=>"UPI"),
                array("name"=>"LOVEPREET SINGH","bank_name"=>"Bank of India","ref"=>"UPI"),
                array("name"=>"SUKHWINDER SINGH BRAR","bank_name"=>"Yes Bank Ltd","ref"=>"UPI"),
                array("name"=>"NEW TATA ENGG WORKS ","bank_name"=>"Punjab and Sind Bank","ref"=>"UPI"),
                array("name"=>"GURMAIL SINGH KAMBOH","bank_name"=>"Punjab and Sind Bank","ref"=>"UPI"),
                array("name"=>"SACHIN","bank_name"=>"ICICI Bank","ref"=>"UPI"),
                array("name"=>"RANJIT SARKAR","bank_name"=>"State Bank Of India","ref"=>"UPI"),
                array("name"=>"Mr MANOJ KUMAR","bank_name"=>"Central Bank Of India","ref"=>"UPI"),
                array("name"=>"JAGDEEP SINGH","bank_name"=>"HDFC BANK LTD","ref"=>"NA"),
                array("name"=>"SARABJIT SINGH","bank_name"=>"Axis Bank Ltd.","ref"=>"UPI"),
                array("name"=>"GAGANDEEP SHAHI","bank_name"=>"Axis Bank Ltd.","ref"=>"UPI"),
                array("name"=>"AKBAR KHAN","bank_name"=>"HDFC BANK","ref"=>"UPI"),
                array("name"=>"DAVINDER SINGH","bank_name"=>"Punjab National Bank","ref"=>"UPI"),
                array("name"=>"SUKHPREET","bank_name"=>"Axis Bank","ref"=>"NA"),
                array("name"=>"RAJBHINDER KAUR","bank_name"=>"Punjab National Bank","ref"=>"UPI"),
                array("name"=>"ANIL KUMAR SO SOVREN","bank_name"=>"Punjab National Bank","ref"=>"UPI"),
                array("name"=>"GURDIT SINGH SO GURDE","bank_name"=>"Bank of India","ref"=>"UPI"),
                array("name"=>"HARJOT K","bank_name"=>"State Bank Of India","ref"=>"NA"),
                array("name"=>"GURJANT SINGH GAHIR","bank_name"=>"Axis Bank Ltd.","ref"=>"UPI"),
                array("name"=>"BASANT SINGH","bank_name"=>"HDFC BANK LTD","ref"=>"UPI"),
                array("name"=>"PARAMJIT KAUR","bank_name"=>"State Bank Of India","ref"=>"UPI"),
                array("name"=>"DANISH MALIK","bank_name"=>"HDFC BANK LTD","ref"=>"UPI   "),
                array("name"=>"SARKAR ROADWAYS","bank_name"=>"State Bank Of India","ref"=>"UPI"),
                array("name"=>"SUMANPREET KAUR WO GU","bank_name"=>"Punjab National Bank","ref"=>"NA"),
                array("name"=>"JASPREET SINGH","bank_name"=>"State Bank Of India","ref"=>"UPI"),
                array("name"=>"Mrs GULFUN NISHA","bank_name"=>"Indian Bank","ref"=>"UPI"),
                array("name"=>"HARMANPREET SINGH","bank_name"=>"HDFC BANK LTD","ref"=>"UPI"),
                array("name"=>"GURBHEJ","bank_name"=>"Capital Small Financ","ref"=>"UPI"),
                array("name"=>"OM CHAND","bank_name"=>"Punjab National Bank","ref"=>"NA"),
                array("name"=>"VISHWAKARMA MACHINERY","bank_name"=>"ICICI Bank","ref"=>"Paymen"),
                array("name"=>"DILEEP KANNAUJIYA ","bank_name"=>"State Bank Of India","ref"=>"UPI"),
                array("name"=>"SANDEEP SINGH SO NACH","bank_name"=>"Bank of India","ref"=>"UPI"),
                array("name"=>"RAJ KUMAR CHOUDHARY","bank_name"=>"India Post Payment","ref"=>"UPI"),
                array("name"=>"Mr Sachen Kumar","bank_name"=>"State Bank Of India","ref"=>"UPI"),
            );
            $debit_delay = array(6,3,5,8,6,9,5,4,3,8);
            $rand_indexs = array(0,1,0,2,0,0,1,0,0,0,2,1,0,1);
    
            $days_between = (strtotime($end_date)-strtotime($start_date))/86400;
            $entry_delay = round($days_between/$no_of_entries);

            //Write Start
            $last_added_date = $start_date;
            $debit = 0;
            $credit = 0;
            $balance = $start_balance;
            $last_entrie_type = "credit";
            $no_of_withdrawal_pending = $no_of_withdrawal_entry;
            $no_of_credit_pending = $no_of_credit_entries;
            $no_of_vendor_pending = $no_of_vendor_entries;
            $debit_gap = $debit_delay[array_rand($debit_delay,3)[0]];
            // echo "<br> OPENING BALANCE | ".$balance;
            $trans_list = array();
            for($i=1;$i<=$no_of_entries;$i++){
                if((($credit-$debit)+$start_balance)>$end_balance){
                    continue;
                }
                if($debit_gap<=0){
                    $debit_gap = $debit_delay[array_rand($debit_delay,3)[0]];
                }
                $randomDateIndexer = $rand_indexs[array_rand($rand_indexs,3)[0]];
                if($randomDateIndexer!=0){
                    $days_gap = $randomDateIndexer;
                } else {
                    $days_gap = $entry_delay;
                }

                $nowdate = date("d-m-Y",strtotime("+$days_gap days",strtotime($last_added_date)));

                $get_mod_of_trans = $account_transaction_mod[rand(0,1)];
                if(($last_entrie_type=="credit" && $get_mod_of_trans == "credit") || $no_of_credit_pending<=0){
                    $get_mod_of_trans = 'debit';
                }
                
                $get_tans_type = $account_transaction_type[$get_mod_of_trans][array_rand($account_transaction_type[$get_mod_of_trans],2)[0]];

                if($get_mod_of_trans=="debit"){
                    $get_add_or_deduction_balance = round(rand($account_transaction_limits[$get_mod_of_trans]['min'],$account_transaction_limits[$get_mod_of_trans]['max']),-1);
                    $debit += $get_add_or_deduction_balance;
                    $balance = $balance-$get_add_or_deduction_balance;
                } else {
                    // round($estimate_atleast_credit_per_trans,-4)
                    $get_add_or_deduction_balance = round(rand($account_transaction_limits[$get_mod_of_trans]['min'],$account_transaction_limits[$get_mod_of_trans]['max']),-4);
                    $credit += $get_add_or_deduction_balance;
                    $balance = $balance+$get_add_or_deduction_balance;
                }

                $mod_of_trans = $mod_of_transction_detail[$get_tans_type][array_rand($mod_of_transction_detail[$get_tans_type],2)[0]];
                $trans_no = strtoupper($this->random_string('alnum', 4)).$this->random_string('numeric', 12);
                $get_trans_detail = "";
                $get_trans_detail .= $get_tans_type;
                if($get_tans_type=='NEFT'){
                    $acc_detail = $account_list[array_rand($account_list,3)[0]];
                    $get_trans_detail .="/".$trans_no."/". substr($acc_detail['account_holder'], 0, -3)."/".$acc_detail['bank_name'];
                } else if($get_tans_type=='IMPS'){
                    $acc_detail = $account_list[array_rand($account_list,3)[0]];
                    $get_trans_detail .="/".$acc_detail['account_type']."/".$trans_no."/". substr($acc_detail['account_holder'], 0, -3)."/".$acc_detail['bank_name'];
                } else if($get_tans_type=='UPI'){
                    if($mod_of_trans=="P2A"){
                        $upi_trans = $p2a_list[array_rand($p2a_list,3)[0]];
                        
                        $get_trans_detail .="/".$mod_of_trans."/".$trans_no."/". $upi_trans['name']."/".$upi_trans['ref']."/".$upi_trans['bank_name'];
                    } else {
                        $upi_trans_p2m = $p2m_list["UPI"][array_rand($p2m_list["UPI"],3)[0]];
                        $get_trans_detail .="/".$mod_of_trans."/".$trans_no."/". $upi_trans_p2m['name']."/".$upi_trans_p2m['bank'];
                    }
                    
                } 
                
            
                // echo "<br>". sprintf("%02d",$i)." | $nowdate | $get_mod_of_trans | $get_tans_type | $get_add_or_deduction_balance | $balance";
                array_push($trans_list,array(
                    "date"=>$nowdate,
                    "title"=>"$get_trans_detail",
                    "debit"=>$get_mod_of_trans=="debit"? sprintf("%.2f", $get_add_or_deduction_balance):'',
                    "credit"=>$get_mod_of_trans=="credit"? sprintf("%.2f", $get_add_or_deduction_balance):'',
                    "balance"=>$balance
                ));

                $last_added_date = $nowdate;
                if($get_mod_of_trans=="credit"){
                    $no_of_credit_pending--;
                } else {
                    if($no_of_withdrawal_pending>0){
                        $no_of_withdrawal_pending--;
                    } else {
                        $no_of_vendor_pending--;
                    }
                }
                $last_entrie_type = $get_mod_of_trans;
                $debit_gap--;
            }
            // echo "<br> C$no_of_credit_pending | W$no_of_withdrawal_pending | V$no_of_vendor_pending | $credit = $debit Balance ".($credit-$debit)+$start_balance;
            $entry_uuid = (string) Str::uuid();
            Entry::insert([
                "uuid"=>$entry_uuid,
                "entries"=>json_encode(compact('start_balance','trans_list','credit','debit','balance'))
            ]);
            return redirect(route('view_entries',['uuid'=>$entry_uuid]));
            // return view('test.test',compact('start_balance','trans_list','credit','debit','balance'));
          
            // $mod_of_transction = array(
            //     "transfer"=>array("NEFT","UPI","IMPS","RTGS"),
            //     "vendor"=>array("UPI","POS")
            // );
        }

    public function entries($uuid)
        {
            $entries_data = Entry::whereUuid($uuid)->first();
            if(!empty($entries_data)){
                $entry_json = json_decode($entries_data->entries,true);
                $start_balance = $entry_json['start_balance'];
                $trans_list = $entry_json['trans_list'];
                $credit = $entry_json['credit'];
                $debit = $entry_json['debit'];
                $balance = $entry_json['balance'];
                return view('test.test',compact('uuid','start_balance','trans_list','credit','debit','balance'));
            }
            return "Wrong Unique Id:$uuid";
        }

    public function exportEntries(Request $request,$uuid,$type)
        {
            $entries_data = Entry::whereUuid($uuid)->first();
            if(!empty($entries_data)){
                $entry_json = json_decode($entries_data->entries,true);
                $start_balance = $entry_json['start_balance'];
                $trans_list = $entry_json['trans_list'];
                $credit = $entry_json['credit'];
                $debit = $entry_json['debit'];
                $balance = $entry_json['balance'];

                if($type=="text"){
                    $content = "Tran Date | Chq No | Particulars | Debit | Credit | Balance | Init. Br \n";
                    $content .= " |   | OPENING BALANCE  |   |   | $start_balance |   \n";
                    foreach ($trans_list as  $list) {
                        $content .= $list['date']." |  | ".$list['title']." | ".$list['debit']." | ".$list['credit']." | ".$list['balance']." | Init. Br \n";
                    }
                    $content .= " |   | TRANSACTION TOTAL  | $debit  | $credit  |  |   \n";
                    $content .= " |   | CLOSING BALANCE  |   |   | $balance |   \n";
              
                    
                    // file name to download
                    $fileName = $uuid."-db.txt";
                    
                    // make a response, with the content, a 200 response code and the headers
                    return Response::make($content, 200, [
                    'Content-type' => 'text/plain', 
                    'Content-Disposition' => sprintf('attachment; filename="%s"', $fileName),
                    
                    ]);
                } else if($type=="excel"){
                    
                    $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load(storage_path()."/xlsx/empty.xlsx");
                    $sheet = $spreadsheet->getActiveSheet();
                    //Row1
                    $sheet->setCellValue('A1','Tran Date');
                    $sheet->setCellValue('B1','Chq No'); 
                    $sheet->setCellValue('C1','Particulars ');
                    $sheet->setCellValue('D1','Debit ');
                    $sheet->setCellValue('E1','Credit ');
                    $sheet->setCellValue('F1','Balance ');
                    $sheet->setCellValue('G1','Init. Br ');
                    //Row2  
                    $sheet->setCellValue('A2','');
                    $sheet->setCellValue('B2',''); 
                    $sheet->setCellValue('C2','OPENING BALANCE');
                    $sheet->setCellValue('D2','');
                    $sheet->setCellValue('E2','');
                    $sheet->setCellValue('F2',$start_balance);
                    $sheet->setCellValue('G2','');

                    $spreadsheetrow = 3;
                    foreach ($trans_list as  $list){
                        $sheet->setCellValue('A'.$spreadsheetrow,$list['date']);
                        $sheet->setCellValue('B'.$spreadsheetrow,"");
                        $sheet->setCellValue('C'.$spreadsheetrow,$list['title']);
                        $sheet->setCellValue('D'.$spreadsheetrow,$list['debit']);
                        $sheet->setCellValue('E'.$spreadsheetrow,$list['credit']);
                        $sheet->setCellValue('F'.$spreadsheetrow,$list['balance']);
                        $sheet->setCellValue('G'.$spreadsheetrow,'');
                        $spreadsheetrow++;
                    }
                    //Row 2 Last
                    $sheet->setCellValue('A'.$spreadsheetrow,'');
                    $sheet->setCellValue('B'.$spreadsheetrow,''); 
                    $sheet->setCellValue('C'.$spreadsheetrow,'TRANSACTION TOTAL');
                    $sheet->setCellValue('D'.$spreadsheetrow,$debit);
                    $sheet->setCellValue('E'.$spreadsheetrow,$credit);
                    $sheet->setCellValue('F'.$spreadsheetrow,'');
                    $sheet->setCellValue('G'.$spreadsheetrow,'');
                    $spreadsheetrow++;
                    //Row Last
                    $sheet->setCellValue('A'.$spreadsheetrow,'');
                    $sheet->setCellValue('B'.$spreadsheetrow,''); 
                    $sheet->setCellValue('C'.$spreadsheetrow,'CLOSING BALANCE ');
                    $sheet->setCellValue('D'.$spreadsheetrow,'');
                    $sheet->setCellValue('E'.$spreadsheetrow,'');
                    $sheet->setCellValue('F'.$spreadsheetrow,$balance);
                    $sheet->setCellValue('G'.$spreadsheetrow,'');

                    $writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet, 'Xlsx'); 
                    // $filepath = "/xlsx/new-registration-report-".date("d-m-Y",strtotime($start))."-to-".date("d-m-Y",strtotime($end)).".xlsx";
                    $filepath = "/xlsx/db-".$uuid.".xlsx";
                    $writer->save(storage_path().$filepath);
                    $pdfSavePath = storage_path().$filepath;
                    return response()->file($pdfSavePath, [
                        'Content-Disposition' => str_replace('%name', "DB_".$uuid.'.xlsx', "inline; filename=\"%name\"; filename*=utf-8''%name"),
                        'Content-Type'        =>  'vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                    ]);
                } else if($type=="pdf"){
                    $pdf = PDF::loadView('test.pdf', compact('uuid','start_balance','trans_list','credit','debit','balance'));
                    return $pdf->download("DB-$uuid.pdf");
                } else {
                    return "Something went wrong";
                }
            }
            return "Something went wrong";
        }
    
   

    public function random_string($type = 'alnum', $len = 8)
        {
            switch ($type)
            {
                case 'basic':
                    return mt_rand();
                case 'alnum':
                case 'numeric':
                case 'nozero':
                case 'alpha':
                    switch ($type)
                    {
                        case 'alpha':
                            $pool = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                            break;
                        case 'alnum':
                            $pool = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
                            break;
                        case 'numeric':
                            $pool = '0123456789';
                            break;
                        case 'nozero':
                            $pool = '123456789';
                            break;
                    }
                    return substr(str_shuffle(str_repeat($pool, ceil($len / strlen($pool)))), 0, $len);
                case 'md5':
                    return md5(uniqid(mt_rand()));
                case 'sha1':
                    return sha1(uniqid(mt_rand(), TRUE));
            }
        }

    public function emailVerify($email)
        {
            try{
                $dec_email = Crypt::decrypt($email);
                $user = User::where('email',$dec_email)->whereNull('email_verified_at')->first();
                if(!empty($user)){
                    $user->email_verified_at = date('now');
                    if($user->save()){
                        return 'Email Verified. Login now';
                    } 
                    return 'Something went wrong!';
                }
                return 'Something went wrong!';
            } catch(\Throwable){
                return 'Something went wrong!';
            }
        }

    public function test()
        {

            // $getUsers = DB::table('jasa_merge.users as jsuser')
            // ->get();
            // return $getUsers;
            $getUsers = DB::table('jasa_server.users as jsuser')->where('jsuser.UserTypeId',5)->where('jsuser.CompanyId',7)
            ->get();

            foreach($getUsers as $list){
                $getUsersExist = DB::table('jasa_merge.users')->where('id',$list->Id)->exists();
                if($getUsersExist){
                    continue;
                }
                $list->examinee = DB::table('jasa_server.Examinee')->where('UserId',$list->Id)->first();
                if(!empty($list->examinee)){
                    $list->is_examinee = true;
                } else {
                    $list->is_examinee = false;
                }

                $list->address = DB::table('jasa_server.UserAddress')->where('UserId',$list->Id)->first();
                if(!empty($list->address)){
                    $list->is_address = true;
                } else {
                    $list->is_address = false;
                }

                $img = '';
                if($list->is_examinee==true && $list->examinee->UserImagePath!=null){
                    $url = 'https://jasaelearning.com'.$list->examinee->UserImagePath;
                    $url = str_replace(" ", "%20", $url);
                    $img = Str::uuid()->toString().'.jpg';
                    file_put_contents(storage_path("userimages/").$img, file_get_contents($url));
                }

                $merge_insert = [
                    "id"=>$list->Id,
                    "firstName"=>$list->Name??null,
                    "middleName"=>"",
                    "lastName"=>"",
                    "date_of_birth"=>"",
                    "email"=>$list->Email??null,
                    "phone"=>$list->Phone??null,
                    "is_employee"=>1,
                    "address_line1"=>$list->is_address==true?$list->address->AddressLine1:null,
                    "address_line2"=>$list->is_address==true?$list->address->AddressLine2:null,
                    "city"=>$list->is_address==true?$list->address->City:null,
                    "state"=>$list->is_address==true?$list->address->StateId:null,
                    "country"=>$list->is_address==true?$list->address->ZipCode:null,
                    "zip_code"=>$list->is_address==true?$list->address->CountryId:null,
                    "department"=>null,
                    "rank"=>"1",
                    "profile_pic"=>$img,
                    "joining_date"=>$list->JoiningDate,
                    "gender"=>$list->is_examinee==true?($list->examinee->Gender==1?'Male':'Female'):null,
                    "account_lock"=>$list->IsLocked,
                    "employee_type"=>"1",
                    "employee_id"=>$list->EmploymentId,
                    "supervisor_name"=>$list->is_examinee==true?$list->examinee->SupervisorName:null,
                    "supervisor_email"=>$list->is_examinee==true?$list->examinee->SupervisorEmail:null,
                    "nric_number"=>$list->is_examinee==true?$list->examinee->NRIC:null,
                    "username"=>$list->UserName,
                    "password"=>Hash::make($list->Password),
                    "token"=>null,
                    "invite_sent"=>null,
                    "status"=>$list->IsActive??1,
                    "last_login_time"=>$list->LastLogin??null,
                    "image"=>$img,
                    "verify_image_status"=>$list->is_examinee==true?$list->examinee->IsImageApprove:null,
                    "created_at"=>null,
                    "updated_at"=>null,
                    "c_by"=>null,
                    "u_by"=>null,
                    "d_by"=>null
                ];

                $getUsers = DB::table('jasa_merge.users')->insert($merge_insert);
            }

            return $getUsers;
        }

    public function renderFormBuilderGuideVideo(Request $request)
        {
            $user_id = base64_decode(base64_decode($request->temptoken));
            $workout_id = base64_decode(base64_decode($request->tempid));
            $workout = FormBuilderWorkout::where('id',$workout_id)->first();
            // if(empty($workout)){
            //     return abort(404, 'Page not found');
            // }
            return view('public.form-builder-guide',compact('user_id','workout','workout_id'));
        }

    public function uploadFormBuilderGuideVideo(Request $request)
        {
            $request->validate([
                'file' => 'required|file', 
            ]);

            try {
                $file = $request->file('file');
                $fileName = md5($file->getClientOriginalName() . time()) . "." . $file->getClientOriginalExtension();
                $file->move(storage_path().'/formbuilderuploads'.'/', $fileName);

                $info = array(
                    "user_id"=>$request->user_id,
                    "video_path"=>$fileName,
                    "workout_id"=>$request->workout_id,
                    "description"=>''
                );
                
                FormBuilderUpload::insert($info);

                return response()->json([
                    'status' => 'success',
                    'message' => 'File uploaded successfully!',
                    'file_path' => $fileName,
                ]);
            } catch (\Exception $e) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Failed to upload the file.',
                    'error' => $e->getMessage(),
                ], 500);
            }
        }


}
