<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Setting;

class MasterSettingController extends Controller
{
    //
    public function getSettings(Request $request)
        {
            $master = Setting::get();
            return view('settings.master-settings',compact('master'));
        }

    public function saveSettings(Request $request)
        {
            $master = Setting::get();
            foreach($master as $setting)
                {
                    if($request->has($setting->id)){
                        $setting = Setting::where('id',$setting->id)->first();
                        if($setting->type=="bool"){
                            $setting->value = ($request[$setting->id]=="on"?true:false);
                        } else {
                            $setting->value = $request[$setting->id];
                        }
                        $setting->save();
                    } else {
                        if($setting->type=="bool"){
                            $setting = Setting::where('id',$setting->id)->first();
                            $setting->value = false;
                            $setting->save();
                        }
                    }
                    
                }
            return redirect()->back()->with('success',"Settings updated");
        }
}
