<?php

namespace App\Jobs;

use App\Models\MealPicture;
use App\Models\User;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class MealReminder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        // $getTime = [date('H:i',strtotime('now')),date('H:i',strtotime('+5 minutes'))];
        $currentDate = date('Y-m-d',strtotime('now'));
        $getAppUsers = User::where('role','appuser')->pluck('id');
        $ctl = 0;
        foreach($getAppUsers as $list){
            $getReminders = MealPicture::whereDate('date',$currentDate)->where('user_id',$list)->exists();
            if(!$getReminders){
                notify_user($list,"Don't miss meal upload today.","Upload your meal.");
                $ctl++;
            }
        }
        echo $ctl;
    }
}
