<?php

namespace App\Jobs;

use App\Models\MyReminder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class SendReminder implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $getTime = [date('H:i',strtotime('now')),date('H:i',strtotime('+5 minutes'))];
        $currentWeekCount = date('w',strtotime('now'));
        $getReminders = MyReminder::whereBetween('time',$getTime)->get(); 
        foreach($getReminders as $list){
            $week = json_decode($list->weekdays);
            if($week[$currentWeekCount]){
                notify_user($list->user_id,"Scheduled Reminder!!","reminder name is ".$list->name);
            }
        }
        echo count($getReminders);
    }
}
