<?php

namespace App\Jobs;

use App\Models\User;
use App\Models\WeeklyUpdate;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class WeeklyAlert implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function handle()
    {
        $between = $this->x_week_range2(date('Y-m-d',strtotime('now')));
        if((date('Y-m-d',strtotime('now'))==$between[1]) || (date('Y-m-d',strtotime('-1 day',strtotime($between[1])))==date('Y-m-d',strtotime('now')))){
            $getWeeklyUpdatePending = WeeklyUpdate::whereBetween('date',$between)->pluck('user_id');
            $getAppUsers = User::where('role','appuser')->whereNotIn('id',$getWeeklyUpdatePending)->pluck('id');
            foreach($getAppUsers as $list){
                notify_user($list,"Missed!!","Update your weekly update.");
            }
            echo "Done";
            return;
        } else {
            echo 'not today';
            return;
        }
    }
    private function x_week_range2($date)
    {
        $ts = strtotime($date);
        $start = strtotime('monday this week', $ts);
        $end = strtotime('sunday this week', $ts);
        return array(date('Y-m-d', $start), date('Y-m-d', $end));
    }
}
