<!DOCTYPE html>
<html lang="en">

<head>
    <title>App Slides</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('slides','create')) <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Slide</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >App Slides</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>App Slides</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Title</th>
                                            <th>Picture</th>
                                            <th>Status</th>
                                            @if(permission('slides','update') || permission('slides','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($slides as $index=> $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{!! $list->title !!}</td>
                                            <td><img src="{{env('APP_URL_STR').'appslides/'}}{{$list->file_path}}" height="70" width="70"></td>
                                            <td>
                                                @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                @if($list->status==2)<span class="badge bg-gradient-warning">Draft</span>@endif
                                                @if($list->status==0)<span class="badge bg-gradient-danger">Inactive</span>@endif
                                            </td>
                                            @if(!permission('slides','update') || permission('slides','delete'))
                                            <td>
                                                @if(permission('slides','update'))
                                                    <a href="{{route('status-app-slides',['id'=>$list->id])}}" onclick="return confirm('Change Status?')">
                                                        <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-refresh-cw"></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button>
                                                @endif
                                                @if(permission('slides','delete'))
                                                    <a href="{{route('delete-app-slides',['id'=>$list->id])}}" onclick="return confirm('Are you sure? Delete Slide')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="5">Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $slides->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Slide</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save-slide')}}" method="post" enctype='multipart/form-data'>
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="title_p">Title</label>
                                <input type="text" class="form-control" name="title" id="title_p" aria-describedby="emailHelp" required placeholder="Title">
                            </div>
                            <div class="form-group">
                                <label for="imape_p">Picture</label>
                                <input type="file" name="image" class="form-control" id="imape_p" required >
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    @forelse($slides as $index=> $list)
    <div id="exampleModalLive{{$index}}q" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Add a New Slide</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('update-slide',['id'=>$list->id])}}" method="post" enctype='multipart/form-data'>
                    @csrf
                    <div class="row">
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="title_p">Title</label>
                                <input type="text" class="form-control" value="{{$list->title}}" name="title" id="title_p" aria-describedby="emailHelp" required placeholder="Title">
                            </div>
                            <div class="form-group">
                                <label for="imape_p">Picture</label>
                                <input type="file" name="image" class="form-control" id="imape_p"  @if(empty($list->file_path)) required @endif >
                                <img src="{{env('APP_URL_STR').'appslides/'}}{{$list->file_path}}" height="70" width="70">
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>
</body>

</html>