<!DOCTYPE html>
<html lang="en">

<head>
    <title>App Users</title>
    @include('includes.header')
    <script src="{{asset('assets/js/bs/bootstrap.min.css')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.css')}}"></script> 

</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('app_users','update'))<button class="m-b-10 btn bg-gradient-info pr 
" data-toggle="modal" data-target="#exampleModalLive">Add a New App User</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >App Users</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>App Users</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                            <table id="getUserData" class="table table-striped" style="width:100%">
                            </table>
                                
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New App User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('store-app-user')}}" id="storeUser" method="post">
                    <div class="row">
                        @csrf
                        <div class="col-md-6">
                                <div class="form-group">
                                    <label for="myname">Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="myname" id="myname" required placeholder="Enter name">
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputEmail1">Email address <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="email" id="exampleInputEmail1" aria-describedby="emailHelp" placeholder="Enter email" required>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputPassword1">Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" id="exampleInputPassword1" placeholder="Password" required>
                                </div>
                                <div class="form-group">
                                    <label for="exampleInputPassword1">Confirm Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="confirm_password" id="exampleInputPassword1" placeholder="Confirm Password" required>
                                    <span class="err-msg text-danger"></span>
                                </div>
                        
                        </div>
                        <div class="col-md-6">
                        
                                <div class="form-group">
                                    <label>Date of Birth <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" name="dob" required>
                                </div>
                                <div class="form-group paidUserCheck">
                                    <label for="paid_plan">Plan <span class="text-danger">*</span></label>
                                    <select class="form-control" id="paid_plan" name="paid_plan" required >
                                        <option value="">Select Plan</option>
                                        @foreach($plans as $list)<option value="{{$list->id}}">{{$list->name}} - {{$list->duration}} - {{$list->amount}}</option> @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Mobile Number <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" name="mobileno" placeholder="Mobile no." required>
                                </div>
                        
                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>




    <script src="{{asset('assets/js/bs/dataTables.js')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.js')}}"></script>    

    <script>
    
            // $('#example').DataTable({
            new DataTable('#getUserData', {
                "ajax": {
                    "url": "{{route('get-app-user-datatable')}}",
                    "data": function ( d ) {
                            d.additionalFilter='';
                        },
                    "dataSrc": function ( json ) {
                        return json.data;
                    }
                },
                fixedHeader: true,
                responsive: true,
                processing: true,
                serverSide: true,
                columns: [
                    { data: 'id',title:"#" },
                    { data: 'name',title:"Name" },
                    { data: 'email',title:"Email" },
                    { data: 'is_subscription',title:"Subscription" ,
                        "render":function(data,type,row){
                            if(data==0){
                                return `<span class="badge bg-gradient-dark">Free</span>`;
                            }else if(data==1){
                                return `<span class="badge bg-gradient-success">Paid</span>`;
                            }
                            
                        }
                    },
                    { data: 'diet_plan',title:"Diet Plan",
                        "render":function(data,type,row){
                            var userDetailsURL = "{{ route('user_diet_plan', ['id' => ':id']) }}";
                                userDetailsURL = userDetailsURL.replace(':id', row['id']);
                            if(data==null || data==''){
                                return `<a class="btn btn-sm bg-gradient-warning" href="`+userDetailsURL+`"><i class="fa fa-code" aria-hidden="true"></i> Create Diet Plan</a>`;
                            }
                            return `<a class="btn btn-sm bg-gradient-info" href="`+userDetailsURL+`"><i class="fa fa-code" aria-hidden="true"></i> Diet Plan</a>`;
                        }
                    },
                    { data: 'status',title:"Status",
                        "render":function(data,type,row){
                            if(data==1){
                                return `<span class="badge bg-gradient-success">Active</span>`;
                            } else if(data==0){
                                return `<span class="badge bg-gradient-danger">Disabled</span>`;
                            }
                            
                        }
                    },
                    { data: 'id',title:"Action",orderable:false,
                        "render":function(data,type,row){
                            var userDetailsURL = "{{ route('app-users-sts', ['id' => ':id']) }}";
                                userDetailsURL = userDetailsURL.replace(':id', data);
                                var userUpdateURL = "{{ route('app-users-disable', ['id' => ':id']) }}";
                                userUpdateURL = userUpdateURL.replace(':id', data);
                                var userDeleteURL = "{{ route('app-users-delete', ['id' => ':id']) }}";
                                userDeleteURL = userDeleteURL.replace(':id', data);
                            return   `@if(permission('app_users','sts') || permission('app_users','update') || permission('app_users','delete'))
                                        <td>
                                            @if(permission('app_users','sts'))
                                                <a href="`+userDetailsURL+`" >
                                                    <button class="btn btn-sm bg-gradient-dark"><i class="feather icon-eye"></i></button>
                                                </a>
                                            @endif
                                            @if(permission('app_users','update'))
                                                <!-- <button class="btn btn-sm bg-gradient-info pr"><i class="feather icon-edit"></i></button> -->
                                                <a href="`+userUpdateURL+`" onclick="return confirm('Change Status?')">
                                                    <button class="btn btn-sm bg-gradient-secondary"><i class="feather icon-slash"></i></button>
                                                </a>
                                            @endif
                                            @if(permission('app_users','delete'))
                                                <a href="`+userDeleteURL+`"  onclick="return confirm('Are you sure? Delete User')">
                                                    <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                </a>
                                            @endif
                                        </td>
                                        @endif`;
                        }
                    },
                ],
                language: {
                    searchPlaceholder: "By Name, Email, Phone"
                }
            });

        $(document).on('change','#usertype',(res)=>{
            var type = res.target.value;
            if(type=="free"){
                $('.paidUserCheck').hide();
                $('#paid_plan').removeAttr('required');
            }
            if(type=="paid"){
                $('.paidUserCheck').show();
                $('#paid_plan').attr('required',true);
            }
            console.log(type)
        });

        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>
</body>

</html>