<!DOCTYPE html>
<html lang="en">

<head>
    <title>{{$userDetail->name}} - Dashboard Statistics</title>
    @include('includes.header')
    <style>
         .card{

        width: 100%;
        border: none;
        border-radius: 15px;
        padding: 8px;
        background-color: #fff;
        position: relative;
        min-height: 330px;
        }

        .upper{

        height: 100px;

        }

        .upper img{

        width: 100%;
        border-top-left-radius: 10px;
        border-top-right-radius: 10px;

        }

        .user{
        position: relative;
        }

        .profile img{


        height: 80px;
        width: 80px;
        margin-top:2px;


        }

        .profile{

        position: absolute;
        top:-50px;
        left: 38%;
        /* height: 90px;
        width: 90px;
        border:3px solid #fff;

        border-radius: 50%; */

        }

        .follow{

        border-radius: 15px;
        padding-left: 20px;
        padding-right: 20px;
        height: 35px;
        }

        .stats span{

        font-size: 29px;
        }
    </style>
        <style>
        .rate {
            float: left;
            height: 46px;
            padding: 0 10px;
        }
        .rate:not(:checked) > input {
            position:absolute;
            top:-9999px;
        }
        .rate:not(:checked) > label {
            float:right;
            width:1em;
            overflow:hidden;
            white-space:nowrap;
            cursor:pointer;
            font-size:30px;
            color:#ccc;
        }
        .rate:not(:checked) > label:before {
            content: '★ ';
        }
        .rate > input:checked ~ label {
            color: #ffc700;    
        }
        .rate:not(:checked) > label:hover,
        .rate:not(:checked) > label:hover ~ label {
            color: #deb217;  
        }
        .rate > input:checked + label:hover,
        .rate > input:checked + label:hover ~ label,
        .rate > input:checked ~ label:hover,
        .rate > input:checked ~ label:hover ~ label,
        .rate > label:hover ~ input:checked ~ label {
            color: #c59b08;
        }
    </style>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="page-header-title">
                                <h5 class="m-b-10">{{$userDetail->name}} - Dashboard Statistics</h5>
                                <a class="btn btn-sm @if(!empty($userDetail->diet_plan)) bg-gradient-info @else bg-gradient-warning @endif float-right mr-2 mb-2 " href="{{route('user_diet_plan',['id'=>$userDetail->id])}}"><i class="fa fa-code" aria-hidden="true"></i>@if(empty($userDetail->diet_plan)) Create @endif Diet Plan</a>
                                <a class="btn btn-sm bg-gradient-secondary float-right mr-2 mb-2"href="{{route('app-users-disable',['id'=>$userDetail->id])}}" onclick="return confirm('Change Status?')"><i class="fa fa-ban" aria-hidden="true"></i> Enable/Disable</a>
                                <a class="btn btn-sm bg-gradient-warning float-right mr-2 mb-2" href="tel:{{$userDetail->phone}}"><i class="fa fa-phone" aria-hidden="true"></i> Get Call</a>
                                <a class="btn btn-sm bg-gradient-dark float-right mr-2 mb-2" href="mailto:{{$userDetail->email}}"><i class="fa fa-envelope" aria-hidden="true"></i> Send Email</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- table card-1 start -->
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6">
                    <div class="card flat-card">
                        <div class="row-table">
                            <div class="container d-flex justify-content-center align-items-center">
                                <div class="card">
                                    <div class="upper">
                                        <img src="https://i.imgur.com/Qtrsrk5.jpg" class="img-fluid">
                                    </div>
                                    <div class="user text-center">
                                        <div class="profile">
                                        <img src="{{$userDetail->image}}" class="rounded-circle" width="80">
                                        </div>
                                    </div>
                                    <div class="mt-5 text-center">
                                        <h4 class="mb-0">{{$userDetail->name}}</h4>
                                        <table class="table table-striped">
                                            <tr>
                                                <td class="p-1">Status</td>
                                                <td class="p-1"><span class="badge @if($userDetail->status==1)
                                                    bg-gradient-success
                                                @elseif($userDetail->status==0)
                                                    bg-gradient-danger
                                                @endif  ">
                                                @if($userDetail->status==1)
                                                    Active
                                                @elseif($userDetail->status==0)
                                                    Disabled
                                                @endif</span></td>
                                            </tr>
                                            <tr>
                                                <td class="p-1">Email</td>
                                                <td class="p-1">{{$userDetail->email??''}}</td>
                                            </tr>
                                            <tr>
                                                <td class="p-1">Phone</td>
                                                <td class="p-1">{{$userDetail->phone ?? ''}}</td>
                                            </tr>
                                            <tr>
                                                <td class="p-1">Gender</td>
                                                <td class="p-1" style="text-transform: uppercase;">{{$userDetail->gender??''}}</td>
                                            </tr>
                                            <tr>
                                                <td class="p-1">Date of Birth</td>
                                                <td class="p-1">{{date('d M Y',strtotime($userDetail->dob))??''}}</td>
                                            </tr>
                                        </table>
                                    
                                        <div class="d-none justify-content-between align-items-center mt-4 px-4 " >
                                       
                                            <div class="stats">
                                                <a href="{{route('app-users-disable',['id'=>$userDetail->id])}}" onclick="return confirm('Change Status?')">
                                                    <button class="btn bg-gradient-secondary btn-sm follow"><i class="feather icon-slash" style="font-size: 19px;"></i></button>
                                                </a>
                                            </div>
                                            <div class="stats">
                                                <a href="tel:{{$userDetail->phone}}" >
                                                    <button class="btn bg-gradient-warning btn-sm follow"><i class="feather icon-phone" style="font-size: 19px;"></i></button>
                                                </a>
                                            </div>
                                            <div class="stats">
                                                <a href="mailto:{{$userDetail->email}}" >
                                                    <button class="btn bg-gradient-info btn-sm follow"><i class="feather icon-mail" style="font-size: 19px;"></i></button>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6">
                    <div class="card flat-card">
                        <div class="row-table">
                            <div class="col-12 card-body ">
                                <div class="row">
                                    <div class="col-1">
                                        <i class="icon fas fa-fire text-warning mb-1 d-block"></i>
                                    </div>
                                    <div class="col-10 text-md-center">
                                        <h5>Calories Intake <small class="todayCalories" style="font-size:11px"> ({{date('d F Y')}})</small></h5>
                                        <span class="todayCaloriesHTML"><b>Intake</b>: {{$takenCalories}}
                                        &#160;&#160;<b>Remaining</b>: @if(!empty($userDetail->bmr)){{($userDetail->bmr-$takenCalories)??''}} @else @if(!empty($cbmr)){{($cbmr-$takenCalories)??''}}@endif @endif
                                        &#160;&#160;<b>Total</b>: @if(!empty($userDetail->bmr)){{$userDetail->bmr??''}} @else @if(!empty($cbmr)){{$cbmr??''}}@endif @endif
                                        </span>
                                    </div>
                                    <div class="col-1">
                                        <i class="icon fas fa-refresh text-dark mb-1 d-block changeCaloriesDate" style="    font-size: 16px;
                                            position: absolute;
                                            top: -40px;"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-table" style="border-bottom: 1px solid #ddd;">
                            <div class="col-12 card-body ">
                                <div class="row">
                                    <div class="col-1">
                                        <i class="icon fas fa-dumbbell text-info mb-1 d-block"></i>
                                    </div>
                                    <div class="col-10 text-md-center">
                                        <h5>Current Basal Metabolic Rate</h5>
                                        <span>@if(!empty($cbmr))System Generated : {{$cbmr??''}} calories per day @endif
                                        @if(!empty($userDetail->bmr))@if(!empty($cbmr))<br>@endif Manual Assigned : {{$userDetail->bmr??''}} calories per day @endif
                                        </span>
                                    </div>
                                    <div class="col-1">
                                        <i class="icon fas fa-edit text-dark mb-1 d-block editBMR" style="    font-size: 16px;
                                            position: absolute;
                                            top: -40px;"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-table" style="border-bottom: 1px solid #ddd;">
                            <div class="col-sm-12 card-body br">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon fas fa-ruler-vertical text-c-green mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>Height</h5>
                                        <span>{{str_replace('_',' ',$userDetail->height)??''}}</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon fas fa-weight text-c-red mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>Weight <i class="icon fas fa-edit text-dark mb-1 float-right editWeight" style="    font-size: 16px;"></i></h5>
                                        <span>{{str_replace('_',' ',$userDetail->weight) ?? ''}} </span>
                                         
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        
                        <div class="row-table" style="border-bottom: 1px solid #ddd;">
                            <div class="col-sm-12 card-body br">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon fa fa-trophy text-c-blue mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>Goal</h5>
                                        <span>{{$userDetail->goal??''}}</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-sm-12 card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon fas fa-running text-c-dark mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>Activity Level</h5>
                                        <span>{{$userDetail->activity_level??''}}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-table">
                            <div class="col-sm-12 card-body br">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon fa fa-language text-c-blue mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>Language</h5>
                                        <span>{{$userDetail->lang->name??''}}</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-sm-12 card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon fa fa-globe text-c-yellow mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>Location</h5>
                                        <span>@if(!empty($userDetail->city)){{$userDetail->city->state->country->name??''}} <br> {{$userDetail->city->state->name??''}} <br> {{$userDetail->city->name??''}}@endif
                                            @if(!empty($userDetail->latitude)){{$userDetail->latitude??""}}@endif
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    
                    </div>
                
                </div>
                <!-- table card-1 end -->
                <!-- table card-2 start -->
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6">
                    <div class="card flat-card">
                        <div class="row-table">
                            <div class="col-sm-12 card-body br">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-image text-c-green mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['meal_picture']}}</h5>
                                        <span>Pending Meal Picture <small>(approval)</small></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-list text-c-red mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['weekly_update']}}</h5>
                                        <span>Pending Weekly Update <small>(approval)</small></span>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                        
                        <div class="row-table" style="border-bottom: 1px solid #ddd;">
                            <div class="col-sm-12 card-body br">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-globe text-c-blue mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['meditation']}}</h5>
                                        <span>Upcoming Meditation</span>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-sm-12 card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-feather text-c-yellow mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['missed_meal_7day']}}</h5>
                                        <span>Missed Meal - Last 7 Days</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-table" style="border-bottom: 1px solid #ddd;">
                            <div class="col-sm-12 card-body br">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-paperclip text-c-yellow mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['help_support']}}</h5>
                                        <span>Help Queries</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-bell text-c-green mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['active_reminders']}}</h5>
                                        <span>Active Reminders</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="row-table" >
                            <div class="col-sm-12 card-body br">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-phone text-c-blue mb-1 d-block"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['call_request']}}</h5>
                                        <span>Pending Call Requests</span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 card-body">
                                <div class="row">
                                    <div class="col-sm-4">
                                        <i class="icon feather icon-user text-c-blue mb-1 d-blockz"></i>
                                    </div>
                                    <div class="col-sm-8 text-md-center">
                                        <h5>{{$sts['consultation_query']}}</h5>
                                        <span>Consultation Queries</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- table card-2 end -->
                @if(!empty($userDetail->plan->name))
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 bg-white" style="border:1px solid #e2e2e2">
                    <div >
                        <h6 class="text-center pt-1">Active Plan Detail</h6>
                        <span class="btn bg-gradient-dark btn-sm" onclick="changePlan()"> <i class="fa-solid fa-crown" style="font-size:13px"></i> Upgrade / Downgrade</span>
                        <ul class="list-group" style="list-style-type:none;" >
                            
                            <li class="list-group-item1"> 
                                @if(!empty($userDetail->plan->name)) {{$userDetail->plan->name}}<br>
                                    Duration: {{$userDetail->plan->duration}}<br>
                                    Price: @if($userDetail->plan->amount>0)<span class="badge bg-gradient-warning">&#8377; {{$userDetail->plan->amount}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif <br>
                                    Final Price :@if($userDetail->plan->final_price>0)<span class="badge bg-gradient-info">&#8377; {{$userDetail->plan->final_price}}</span> @else <span class="badge bg-gradient-success">Free</span> @endif <br>
                                    Discount @if($userDetail->plan->discount>0)<span class="badge bg-gradient-info pr">{{$userDetail->plan->discount}}%</span> @endif
                                    @if(!empty($userDetail->gateway_ref))
                                    <br>
                                        Starts On: @if($userDetail->plan->amount>0)<span class="badge bg-gradient-info">{{date('d M Y',strtotime(json_decode($userDetail->gateway_ref)->start??''))}}</span> @endif <br>
                                        Expiry/Renew On: @if($userDetail->plan->amount>0)<span class="badge bg-gradient-info">{{date('d M Y',strtotime(json_decode($userDetail->gateway_ref)->end??''))}}</span> @endif
                                        @if($userDetail->plan->amount>0)
                                            <br>
                                            <form class="float-left" action="{{route('send-notification')}}" method="post" onsubmit="return confirm(`Expiry Soon! \nSent this notification!`)">
                                                @csrf
                                                @method('PUT')
                                                <input type="hidden" name="send_to" value="{{$userDetail->id}}">
                                                <input type="hidden" name="title" value="Expiry Soon!">
                                                <input type="hidden" name="message" value="Don't forgot to renew membership. expiry on: {{date('d M Y',strtotime(json_decode($userDetail->gateway_ref)->end??''))}}">
                                                <button class="btn btn-sm bg-gradient-secondary float-right" style="font-size:10px;margin-right:10px;">Send Renewal Reminder</button>
                                            </form>
                                        @endif
                                    @endif
                                @else
                                <span class="badge bg-gradient-success">Free</span>
                                @endif
                            </li>
                        </ul>
                    </div>
                </div>
                @endif
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="row ">
                        <div class="col-12 text-center" >
                        <label class="pt-2">{{$final_graph_sts['date_string']}}</label>
                        </div>
                        <div class="col-6 text-center" style="border-right:1px solid #e2e2e2;">
                            <label class="pt-2">Diet Update</label><i class="icon fas fa-edit text-dark mb-1 float-right editUpdate" style="padding:8px;font-size: 16px;"></i>
                            <canvas id="dietFollow"></canvas>
                        </div>
                        <div class="col-6 text-center">
                            <label class="pt-2">Workout Update</label><i class="icon fas fa-edit text-dark mb-1 float-right editWorkoutUpdate" style="padding:8px;font-size: 16px;"></i>
                            <canvas id="workoutFollow"></canvas>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">Trainer </h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @if(!empty($is_trainer))
                                <li class="list-group-item text-center">
                                    Trainer Name : {{$is_trainer->user->name ?? ''}}<br>
                                    Email : {{$is_trainer->user->email ?? ''}}<br>
                                    Phone No. : {{$is_trainer->user->phone ?? 'Not Found'}}<br>
                                    <a href="tel:{{$is_trainer->user->phone}}" >
                                        <button class="btn btn-sm bg-gradient-secondary " style="font-size:10px;margin-right:10px;"><i class="fa fa-phone"></i></button>
                                    </a>
                                    <a href="mailto:{{$is_trainer->user->email}}" >
                                        <button class="btn btn-sm bg-gradient-secondary " style="font-size:10px;margin-right:10px;"><i class="fa fa-envelope"></i></button>
                                    </a>
                                </li>
                            @else
                                <li class="list-group-item text-center">A trainer has not been assigned yet.
                                    @if(!empty($userDetail->plan->name))
                                        @if($userDetail->plan->amount>0)
                                            <span class="badge bg-gradient-info pr">Assign Trainer</span>
                                        @endif
                                    @endif
                                    
                                </li>
                            @endif
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div >
                        <h6 class="text-center pt-1">Reminder List <button class="btn btn-sm bg-gradient-dark float-right" style="font-size:10px;margin-right:10px;"><i class="fa fa-plus"></i> </button></h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @forelse($myReminder as $list)
                            <li class="list-group-item">
                                <span class="float-left">
                                    @if($list->is_enabled)<i class="fa fa-circle text-success" aria-hidden="true"></i>@else <i class="fa fa-circle text-secondary" aria-hidden="true"></i>@endif
                                    {{$list->name}} - {{date('h:i A',strtotime($list->time))}} 
                                </span>
                                <span class="float-right">
                                    <button class="btn btn-sm bg-gradient-secondary" style="font-size:10px;"><i class="fa fa-ban"></i></button>
                                    <button class="btn btn-sm bg-gradient-info" style="font-size:10px;"><i class="fa fa-edit"></i></button>
                                    <button class="btn btn-sm bg-gradient-danger" style="font-size:10px;"><i class="fa fa-trash"></i></button>
                                </span>
                                <br>
                                
                               
                                <br>
                                @php $weekdetail = ['mon','tue','wed','thu','fri','sat','sun']; @endphp
                                @foreach(json_decode($list->weekdays) as $indx => $week)
                                    @if($week=='true')
                                        <span class="badge bg-gradient-success">{{$weekdetail[$indx]}}</span>
                                    @else 
                                        <span class="badge bg-gradient-secondary">{{$weekdetail[$indx]}}</span>
                                    @endif
                                @endforeach
                                <br>
                                Message : <small>{{$list->message}}</small>
                                
                            </li>
                            @empty
                            <li class="list-group-item">No Active Reminder</li>
                            @endforelse
                        </ul>
                        
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div >
                        <h6 class="text-center pt-1">Missed Meal - Days</h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @forelse($missedDays as $list)
                            <li class="list-group-item">
                                <span >{{date('l, d M Y',strtotime($list['date']))}}</span>
                                <form class="float-left" action="{{route('send-notification')}}" method="post" onsubmit="return confirm(`Missed meal upload on {{date('l, d M Y',strtotime($list['date']))}} \nSent this notification!`)">
                                    @csrf
                                    @method('PUT')
                                    <input type="hidden" name="send_to" value="{{$userDetail->id}}">
                                    <input type="hidden" name="title" value="Missed meal upload on {{date('l, d M Y',strtotime($list['date']))}}">
                                    <input type="hidden" name="message" value="Don't forgot to upload your meal.">
                                    <button class="btn btn-sm bg-gradient-secondary float-right" style="font-size:10px;margin-right:10px;"><i class="fa fa-bell"></i> </button>
                                </form>
                            </li>
                            @empty
                            <span class="text-center">No Meal Missed</span>
                            @endforelse
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div >
                        <h6 class="text-center pt-1">Assigned Workouts <button class="btn btn-sm bg-gradient-dark float-right" style="font-size:10px;margin-right:10px;"><i class="fa fa-plus"></i> </button></h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @forelse($assignedWorkouts as $list)
                            <li class="list-group-item">{{$list->title??'Workout Removed'}} 
                                <span class="float-right">
                                    <button class="btn btn-sm bg-gradient-dark" style="font-size:10px;"><i class="fa fa-eye"></i></button>
                                    <button class="btn btn-sm bg-gradient-info" style="font-size:10px;"><i class="fa fa-edit"></i></button>
                                    <button class="btn btn-sm bg-gradient-danger" style="font-size:10px;"><i class="fa fa-trash"></i></button>
                                </span>
                            </li>
                            @empty
                            <li class="list-group-item text-center">Not Found Assigned Workouts</li>
                            @endforelse
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">Form Builder Guide - Videos 
                                            <form class="float-left" action="{{route('send-notification')}}" method="post" onsubmit="return confirm(`If you’re interested, you can make a form builder video. \nSent this notification!`)">
                                                @csrf
                                                @method('PUT')
                                                <input type="hidden" name="send_to" value="{{$userDetail->id}}">
                                                <input type="hidden" name="title" value="If you’re interested, you can make a form builder video.">
                                                <input type="hidden" name="message" value="All guidance is shown in the form builder section.">
                                                <button class="btn btn-sm bg-gradient-info float-right" style="font-size:10px;margin-right:10px;"><i class="fa fa-bell"></i> </button>
                                            </form>
                                            </h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @forelse($formBuilderUpload as $list)
                            <li class="list-group-item">{{$list->workoutplan->title ?? "Workout plan not found or Deleted"}} 
                                <span class="float-right">
                                    <button class="btn btn-sm bg-gradient-dark" style="font-size:10px;"><i class="fa fa-video"></i></button>
                                    <button class="btn btn-sm bg-gradient-danger" style="font-size:10px;"><i class="fa fa-trash"></i></button>
                                </span>
                            </li>
                            @empty
                            <li class="list-group-item text-center">Not Found Assigned Workouts</li>
                            @endforelse
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">Approve Meal Picture </h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @forelse($mealPictureApproval as $list)
                            <li class="list-group-item">
                                <img src="{{env('APP_URL_STR').'meal_pictures/'}}{{$list->file_path}}" height="50" width="50">
                                <a href="{{env('APP_URL_STR').'meal_pictures/'}}{{$list->file_path}}" target="_blank"><button class="btn btn-sm bg-gradient-dark"><i class="feather icon-external-link"></i></button></a>
                                {{date('d M Y',strtotime($list->date))}}<br>
                                @if($list->is_active==1)
                                    @if($list->is_approved==1)
                                        <span class="badge bg-gradient-success">Approved</span>
                                    @endif
                                    @if($list->is_approved==0)
                                        @if($list->need_retake==1)
                                        <span class="badge bg-gradient-info">Re-Upload Requested</span>
                                        @endif
                                        @if($list->need_retake==0)
                                        <span class="badge bg-gradient-warning">Pending</span>
                                        @endif
                                    @endif
                                @endif
                                @if($list->is_active==2)<span class="badge bg-gradient-danger">Rejected</span>@endif
                                @if($list->is_active==1)
                                <span class="float-right">
                                    <button class="btn btn-sm bg-gradient-success approvePopup" style="font-size:10px;" data-key="{{$list->id}}" data-img="<?php echo env('APP_URL_STR'); ?>meal_pictures/{{$list->file_path}}"><i class="fa fa-check"></i></button>
                                    <form method="get" class="float-left mr-1" onclick="return confirm('Are you sure!\nChange Status to Retake \n Send Nottification to user');" action="{{route('meal-picture-status',['status'=>'retake','uid'=>$list->id])}}">
                                        <button class="btn btn-sm bg-gradient-dark" style="font-size:10px;"><i class="fa fa-refresh"></i></button>
                                    </form>
                                    <form method="get" class="float-left mr-1" onclick="return confirm('Are you sure!\nChange Status to Reject');" action="{{route('meal-picture-status',['status'=>'reject','uid'=>$list->id])}}">
                                        <button class="btn btn-sm bg-gradient-danger" style="font-size:10px;"><i class="fa fa-times"></i></button>
                                    </form>
                                </span>
                                @endif
                            </li>
                            @empty
                            <li class="list-group-item text-center">Pending Meal Picture Not Found</li>
                            @endforelse
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white">
                    <div class="">
                        <h6 class="text-center pt-1">Weekly Update 
                            <form class="float-right" action="{{route('send-notification')}}" method="post" onsubmit="return confirm(`Hi, this is gentle reminder for update your weekly form. \nSent this notification!`)">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="send_to" value="{{$userDetail->id}}">
                                <input type="hidden" name="title" value="Alert, Weekly Form Pending!">
                                <input type="hidden" name="message" value="Hi, this is gentle reminder for update your weekly form.">
                                <button class="btn btn-sm bg-gradient-info float-right" style="font-size:10px;margin-right:10px;"><i class="fa fa-bell"></i> </button>
                            </form>
                        </h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @forelse($weeklyUpdateForm as $list)
                            <li class="list-group-item">
                                Describe Diet : 
                                {{$list->descibe_diet}}
                                <br>
                                Descibe Workout : 
                                {{$list->describe_workout}}
                                <br>
                                Suggesstion : {{$list->suggestion}}<br>
                                Weight : {{$list->weight}}<br>
                                Update on : {{date('d M Y',strtotime($list->date))}}
                                <!-- <span class="float-right">
                                    <form method="get" class="float-left mr-1" onclick="return confirm('Are you sure!\nChange Status to Completed');" action="{{route('weekly-update-status',['status'=>'complete','uid'=>$list->id])}}">
                                        <button class="btn btn-sm bg-gradient-success" style="font-size:10px;"><i class="fa fa-check"></i></button>
                                    </form>
                                    <form method="get" class="float-left mr-1" onclick="return confirm('Are you sure!\nChange Status to Removed');" action="{{route('weekly-update-status',['status'=>'delete','uid'=>$list->id])}}">
                                        <button class="btn btn-sm bg-gradient-danger" style="font-size:10px;"><i class="fa fa-trash"></i></button>
                                    </form>
                                </span> -->
                            </li>
                            @empty
                            <li class="list-group-item text-center">Pending Weekly Update Not Found</li>
                            @endforelse
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">User workout logs (last 5 records) <button class="btn btn-sm bg-gradient-dark float-right" style="font-size:10px;margin-right:10px;">View All </button></h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @forelse($workoutLog as $list)
                            <li class="list-group-item">
                                <strong>{{date('d M Y',strtotime($list->created_at))}}</strong> <br>
                                <strong>Workout Plan</strong> : {{$list->plans_uuid->title??'Workout plan removed'}}<br>
                                <strong>Workout Plan Day</strong> : {{$list->plan_days_uuid->title??'Workout plan days removed'}}<br>
                                <strong>Workout Day</strong> : {{$list->workout_days_uuid->title??'Workout day removed'}}<br>
                                <strong>Log :</strong> 
                            
                               @if(!empty($list->reps))  Reps : {{$list->reps}} @endif
                               @if(!empty($list->sets)) | Sets : {{$list->sets}} @endif  
                               @if(!empty($list->time)) | Time : {{$list->time}} @endif
                               @if(!empty($list->weight)) | Weight : {{$list->weight}}@endif
                                @if(!empty($list->weight))
                                    Difficulty  : 
                                    @if($list->difficulty<=4)
                                    <span class="badge bg-gradient-success badge-pill">{{$list->difficulty}}</span>
                                    @elseif($list->difficulty>=5 && $list->difficulty<=7)
                                    <span class="badge bg-gradient-warning badge-pill">{{$list->difficulty}}</span>
                                    @elseif($list->difficulty>=8)
                                    <span class="badge bg-gradient-danger badge-pill">{{$list->difficulty}}</span>
                                    @endif
                                @endif
                            </li>
                            @empty
                            <li class="list-group-item text-center">Pending Meal Picture Not Found </li>
                            @endforelse
                        </ul>
                    </div>
                </div>
              
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">Track Physique </h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            <li class="list-group-item text-center">
                                <div class="row">
                                    
                                    <div class="col-6">First<br>
                                        @if(!empty($first))
                                            {{date('d M Y',strtotime($first->date??''))}}<br>
                                            @if(!empty($first->image))
                                            <img src="{{$first->image}}" height="200" class="border" style="width:100%;">
                                            @endif
                                        @endif
                                    </div>
                                    
                                   
                                    <div class="col-6">Last<br>
                                        @if(!empty($last))
                                            {{date('d M Y',strtotime($last->date??''))}}<br>
                                            @if(!empty($last->image))
                                            <img src="{{$last->image}}" height="200" class="border" style="width:100%;">
                                            @endif
                                        @endif
                                    </div>
                                    
                                </div>
                               
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">Body Measurements </h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            @foreach($body_me as $date => $list)
                            <li class="list-group-item text-center">
                                <strong>Date : {{date('d M Y',strtotime($date))}}</strong><br>
                                @foreach($list as $slist)
                                    {{strtoupper($slist->type)}} : {{$slist->value}}<br>
                                @endforeach
                            </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    @if(!empty($is_trainer))
                        <section>
                            <div class="container py-5">
                                <div class="row d-flex justify-content-center">
                                    <div class="col-md-12 col-lg-12 col-xl-12">
                                        <div class="carda" style="background:#fff">
                                            <div class="card-header d-flex justify-content-between align-items-center p-3"
                                                style="border-top: 4px solid #ffa900;">
                                                <h5 class="mb-0">Talk to Coach (Chat)</h5>
                                                <div class="d-flex flex-row align-items-center">
                                                <!-- <span class="badge bg-warning me-3">20</span> -->
                                                </div>
                                            </div>
                                            <div class="card-body thisChat" data-mdb-perfect-scrollbar-init style="position: relative; height: 400px; overflow: scroll;">

                                                <div class="d-flex justify-content-between">
                                                    <p class="small mb-1">{{$userDetail->name}}</p>
                                                    <p class="small mb-1 text-muted">Time</p>
                                                </div>
                                                <div class="d-flex flex-row justify-content-start">
                                                    <i class="feather icon-user border p-2 rounded-circle" style="font-size:22px;height: 40px;"></i>
                                                    <div>
                                                        <p class="small p-2 ms-3 mb-3 rounded-3 bg-body-tertiary">Loading...</p>
                                                    </div>
                                                </div>

                                                <div class="d-flex justify-content-between">
                                                    <p class="small mb-1 text-muted">Time</p>
                                                    <p class="small mb-1">{{$userDetail->name}}</p>
                                                </div>
                                                <div class="d-flex flex-row justify-content-end mb-4 pt-1">
                                                    <div>
                                                        <p class="small p-2 me-3 mb-3 text-white rounded-3 bg-warning">Loading...</p>
                                                    </div>
                                                    <i class="feather icon-user border p-2 rounded-circle" style="font-size:22px;height: 40px;"></i>
                                                </div>

                                                

                                            </div>
                                            <div class="card-footer text-muted d-flex justify-content-start align-items-center p-3">
                                                <div class="input-group mb-0">
                                                <input type="text" class="form-control" name="send_message" placeholder="Type message"
                                                    aria-label="Message" aria-describedby="button-addon2" />
                                                <button data-mdb-button-init data-mdb-ripple-init class="btn bg-gradient-warning" onclick="sendMessage();" type="button" id="button-addon2" style="padding-top: .55rem;">
                                                    <i class="fa fa-paper-plane" aria-hidden="true"></i>
                                                </button>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </section>
                    @else
                        <div class="">
                            <h6 class="text-center pt-1">Talk to Coach (Chat) </h6>
                            <ul class="list-group" style="list-style-type:none;" >
                                <li class="list-group-item text-center">Enable once trainer assigned</li>
                            </ul>
                        </div>
                    @endif
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">Today's Recipe Logs</h6>
                        <ul class="list-group" style="list-style-type:none;" >
                        <div class="list-group">
                            @foreach($recipeLogs as $list)
                            <div class="list-group-item flex-column align-items-start">
                                <div class="d-flex w-100 justify-content-between">
                                <h5 class="mb-1">Log as - {{$list->log_as}}</h5>
                                <small>{{date('h:i a',strtotime($list->created_at))}}</small>
                                </div>
                                @foreach($list->recipe_list as $recipe)
                                    @foreach(json_decode($recipe->recipe_steps) as $recipeLog)
                                    <p class="mb-1">{{$recipeLog->name}} {{$recipeLog->qty}} {{$recipeLog->type}}</p>
                                    @endforeach
                                @endforeach
                            </div>
                            @endforeach
                        </div>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-sm-12 col-lg-6 mb-3 mt-2 bg-white" style="border:1px solid #e2e2e2">
                    <div class="">
                        <h6 class="text-center pt-1">Progress Tracker </h6>
                        <ul class="list-group" style="list-style-type:none;" >
                            <li class="list-group-item text-center">Option Adding Soon</li>
                        </ul>
                    </div>
                </div>
               
            </div>
            <!-- [ Main Content ] end -->
        </div>
    </div>
    @include('includes.footer')
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- custom-chart js -->
    <script>
        async function changePlan(){
            const { value: formValues } = await Swal.fire({
                title: "Change Plan",
                html: `
                    <div style="width:70%;margin-left:15%">
                        <div class="form-group">
                            <label class="float-left" style="font-size:15px">Plan</label>
                            <select id="new_plan" class=" form-control">
                                <option disabled selected value=""> Choose Plan</option>
                                @foreach($allplans as $list)
                                    <option value="{{$list->id}}" @if(($userDetail->plan->id ?? 1)==$list->id) selected disabled @endif>{{$list->name}} @if(($userDetail->plan->id ?? 1)==$list->id) <small class="text-danger">(Activated)</small> @endif</option>,
                                @endforeach
                            </select>
                        </div>
                    </div>
                `,
                focusConfirm: false,
                preConfirm: () => {
                    var new_plan = document.getElementById("new_plan").value;
                    if(new_plan==""){
                        return Swal.showValidationMessage(`Select Plan`);
                    }
                    if(new_plan=="{{($userDetail->plan->id ?? 1)}}"){
                        return Swal.showValidationMessage(`This Plan Already Activated`);
                    }
                   
                    return new_plan
                },
                
            });
            if (formValues) {
                getSts(formValues);
            }
            return;
           
        }
        async function getSts(formValues)
            {
                $("#gen-loading").show();
                $.ajax({url:'{{route("change-user-plan")}}',type: 'PUT',data:{id:formValues,user_id:'{{$userDetail->id}}',_token:"{{csrf_token()}}"},
                        success: function(result) {
                            $("#gen-loading").hide();
                            Swal.fire({
                                position: "top-end",
                                icon: "success",
                                title: result,
                                showConfirmButton: false,
                                timer: 1500
                            }).then(()=>{
                                window.location.reload();
                            });
                        },
                        error: function(request,msg,error) {
                            $("#gen-loading").hide();
                            console.log(request)
                            Swal.fire({
                                position: "top-end",
                                icon: "error",
                                title: request.responseJSON,
                                showConfirmButton: false,
                                timer: 1500
                            }).then(()=>{
                                window.location.reload();
                            });
                        }
                    }
                );  
            }


       
    </script>
    @if(!empty($is_trainer))
    <script>
         window.onload = function(e){ 
            getChat();
            setInterval(() => {
                getChat();
            }, 10000);
        }
        
        function sendMessage()
            {
                var message = $('input[name=send_message]').val();
                if(message=="" || message == undefined){
                    $('input[name=send_message]').css('border','red 1px solid');
                }
                $.ajax({url:'{{route("send-user-chat")}}',type: 'PUT',data:{message:message,trainer_id:'{{$is_trainer->user_id??0}}',user_id:'{{$userDetail->id??0}}',_token:"{{csrf_token()}}"},
                        success: function(result) {
                            $("#gen-loading").hide();
                            Swal.fire({
                                position: "top-end",
                                icon: "success",
                                title: result,
                                showConfirmButton: false,
                                timer: 1500
                            }).then(()=>{
                                $('input[name=send_message]').val('');
                                getChat()
                            });
                        },
                        error: function(request,msg,error) {
                            $("#gen-loading").hide();
                            console.log(request)
                            Swal.fire({
                                position: "top-end",
                                icon: "error",
                                title: request.responseJSON,
                                showConfirmButton: false,
                                timer: 1500
                            }).then(()=>{
                                // window.location.reload();
                            });
                        }
                    }
                ); 
            }
        $(document).on('input','input[name=send_message]',(res)=>{
            if(res.target.value==''){
                $('input[name=send_message]').css('border','red 1px solid');
            } else {
                $('input[name=send_message]').css('border','#d9d9d9 1px solid');
            }
        });
        function getChat(){
            var options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric',hour:"numeric",minute:"numeric",dayPeriod:"narrow" };
            $.ajax({url:'{{route("get-user-chat")}}',type: 'PUT',data:{trainer_id:'{{$is_trainer->user_id??0}}',user_id:'{{$userDetail->id??0}}',_token:"{{csrf_token()}}"},
                        success: function(result) {
                            var dataHtml = '';
                            result.forEach(function(obj) { 
                                var today  = new Date(obj.created_at);
                                if(obj.sender_id=='{{$is_trainer->user_id??0}}'){
                                    dataHtml += `
                                    <div class="mb-4 pt-1">
                                        <div class="d-flex flex-row justify-content-start">
                                            <i class="feather icon-user border p-2 rounded-circle" style="font-size:22px;height: 40px;"></i>
                                            <div>
                                                <p class="small p-2 ms-3 mb-3 rounded-3 bg-body-tertiary">`+obj.message+`</p>
                                            </div>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <p class="small mb-1 text-muted">`+today.toLocaleDateString("en-US", options)+`</p>
                                        </div>
                                    </div>
                                `;
                                } else {
                                    dataHtml += `
                                    <div class="mb-4 pt-1 ">
                                        <div class="d-flex flex-row justify-content-end ">
                                            <div>
                                                <p class="small p-2 me-3 mb-3 text-white rounded-3 bg-warning">`+obj.message+`</p>
                                            </div>
                                            <i class="feather icon-user border p-2 rounded-circle" style="font-size:22px;height: 40px;"></i>
                                        </div>
                                        <div class="d-flex justify-content-end">
                                            <p class="small mb-1 text-muted">`+today.toLocaleDateString("en-US", options)+`</p>
                                        </div>
                                    </div>
 
                                `;
                                }
                                
                             });
                            $('.thisChat').html(dataHtml);
                        },
                        error: function(request,msg,error) { }
                    }
                );
        }



    </script>
    @endif
    <script>
        const ctx = document.getElementById('workoutFollow');
        const data = {
            labels: [
                'Pending',
                'Completed',
            ],
            datasets: [{
                label: 'Workout Update',
                data: [parseInt("{{$final_graph_sts['workout']['not_follow_percent']}}"),parseInt("{{$final_graph_sts['workout']['follow_percent']}}")],
                backgroundColor: [
                'rgb(241 240 240)',
                'rgb(54, 162, 235)'
                ],
                hoverOffset: 4
            }]
        };
        const config = {
            type: 'doughnut',
            data: data,
            plugins:[
                {
                    afterDraw  : function(chart, a, b) {
                        let width = chart.width,
                            height = chart.height,
                            ctx = chart.ctx;
                    
                        ctx.restore();
                        let fontSize = (height / 200).toFixed(2);
                        ctx.font = fontSize + "em sans-serif";
                        ctx.textBaseline = "middle";
                    
                        let text = "{{$final_graph_sts['workout']['follow_percent']}}%",
                            textX = Math.round((width - ctx.measureText(text).width) / 2),
                            textY = height / 2;
                    
                        ctx.fillText(text, textX, textY);
                        ctx.save();
                    }
                }
            ]
        };
        new Chart(ctx, config);

        //Second Chart
        const ctx1 = document.getElementById('dietFollow');
        const data1 = {
            labels: [
                'Pending',
                'Completed'
            ],
            datasets: [{
                label: 'Diet Update ',
                data: [parseInt("{{$final_graph_sts['diet']['not_follow_percent']}}"),parseInt("{{$final_graph_sts['diet']['follow_percent']}}")],
                backgroundColor: [
                'rgb(241 240 240)',
                'rgb(54, 162, 235)'
                ],
                hoverOffset: 4
            }]
        };
        const config1 = {
            type: 'doughnut',
            data: data1,
            plugins:[
                {
                    afterDraw  : function(chart, a, b) {
                        let width = chart.width,
                            height = chart.height,
                            ctx = chart.ctx;
                    
                        ctx.restore();
                        let fontSize = (height / 200).toFixed(2);
                        ctx.font = fontSize + "em sans-serif";
                        ctx.textBaseline = "middle";
                    
                        let text = "{{$final_graph_sts['diet']['follow_percent']}}%",
                            textX = Math.round((width - ctx.measureText(text).width) / 2),
                            textY = height / 2;
                    
                        ctx.fillText(text, textX, textY);
                        ctx.save();
                    }
                }
            ]
        };
        new Chart(ctx1, config1);

        $(document).on('click','.editBMR',()=>{
            Swal.fire({
            html: "Basal Metabolic Rate",
            input: "number",
            inputValue:'@if(!empty($userDetail->bmr)){{$userDetail->bmr??''}}@else @if(!empty($cbmr)){{$cbmr??''}}@endif @endif',
            inputAttributes: {
                autocapitalize: "off",
                placeholder:"BMR value"
            },
            showCancelButton: true,
            confirmButtonText: "Save",
            showLoaderOnConfirm: true,
            preConfirm: async (login) => {
                try {
                    const githubUrl = `
                        {{route("save-user-bmr")}}?bmr=${login}&user={{$userDetail->id??0}}
                    `;
                    const response = await fetch(githubUrl);
                    if (!response.ok) {
                        return Swal.showValidationMessage(`
                        ${JSON.stringify(await response.json())}
                        `);
                    }
                    return response.json();
                } catch (error) {
                Swal.showValidationMessage(`
                    Request failed: ${error}
                `);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        position: "top-end",
                        title: `${result.value.message}`,
                        icon:`${result.value.status}`,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(()=>{
                        window.location.reload();
                    });
                }
            });
        });
        $(document).on('click','.editWeight',()=>{
            Swal.fire({
            html: "Update Weight (in KG)",
            input: "number",
            inputValue:'@if(!empty($userDetail->bmr)){{str_replace('_',' ',$userDetail->weight) ?? ''}}@else 0 @endif',
            inputAttributes: {
                autocapitalize: "off",
                placeholder:"weight value"
            },
            showCancelButton: true,
            confirmButtonText: "Save",
            showLoaderOnConfirm: true,
            preConfirm: async (login) => {
                try {
                    const githubUrl = `
                        {{route("save-user-weight")}}?value=${login}&uid={{$userDetail->id??0}}
                    `;
                    const response = await fetch(githubUrl);
                    if (!response.ok) {
                        return Swal.showValidationMessage(`
                        ${JSON.stringify(await response.json())}
                        `);
                    }
                    return response.json();
                } catch (error) {
                Swal.showValidationMessage(`
                    Request failed: ${error}
                `);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        position: "top-end",
                        title: `${result.value.message}`,
                        icon:`${result.value.status}`,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(()=>{
                        window.location.reload();
                    });
                }
            });
        });

        $(document).on('click','.editUpdate',()=>{
            Swal.fire({
                html: "",
                input: "range",
                inputLabel: "Diet Update",
                inputAttributes: {
                    min: "0",
                    max: "100",
                    step: "1"
                },
                inputValue:"{{$final_graph_sts['diet']['follow_percent']}}",
                showCancelButton: true,
                confirmButtonText: "Save",
                showLoaderOnConfirm: true,
                preConfirm: async (login) => {
                    try {
                        const githubUrl = `
                            {{route("save-user-updates")}}?type=diet&value=${login}&uid={{$userDetail->id??0}}
                        `;
                        const response = await fetch(githubUrl);
                        if (!response.ok) {
                            return Swal.showValidationMessage(`
                            ${JSON.stringify(await response.json())}
                            `);
                        }
                        return response.json();
                    } catch (error) {
                    Swal.showValidationMessage(`
                        Request failed: ${error}
                    `);
                    }
                },
            allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        position: "top-end",
                        title: `${result.value.message}`,
                        icon:`${result.value.status}`,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(()=>{
                        window.location.reload();
                    });
                }
            });
        });
        $(document).on('click','.editWorkoutUpdate ',()=>{
            Swal.fire({
                html: "",
                input: "range",
                inputLabel: "Workout Update",
                inputAttributes: {
                    min: "0",
                    max: "100",
                    step: "1"
                },
                inputValue:"{{$final_graph_sts['workout']['follow_percent']}}",
                showCancelButton: true,
                confirmButtonText: "Save",
                showLoaderOnConfirm: true,
                preConfirm: async (login) => {
                    try {
                        const githubUrl = `
                            {{route("save-user-updates")}}?type=workout&value=${login}&uid={{$userDetail->id??0}}
                        `;
                        const response = await fetch(githubUrl);
                        if (!response.ok) {
                            return Swal.showValidationMessage(`
                            ${JSON.stringify(await response.json())}
                            `);
                        }
                        return response.json();
                    } catch (error) {
                    Swal.showValidationMessage(`
                        Request failed: ${error}
                    `);
                    }
                },
            allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        position: "top-end",
                        title: `${result.value.message}`,
                        icon:`${result.value.status}`,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(()=>{
                        window.location.reload();
                    });
                }
            });
        });
        //changeCaloriesDate
        $(document).on('click','.changeCaloriesDate',()=>{
            Swal.fire({
            html: "Calories Intake Date",
            input: "date",
            inputValue:'{{date("Y-m-d")}}',
            inputAttributes: {
                autocapitalize: "off",
                max: "{{date('Y-m-d')}}",
            },
            showCancelButton: true,
            confirmButtonText: "Get",
            showLoaderOnConfirm: true,
            preConfirm: async (login) => {
                try {
                    const githubUrl = `
                        {{route("get-calories-info")}}?date=${login}&user={{$userDetail->id??0}}
                    `;
                    const response = await fetch(githubUrl);
                    if (!response.ok) {
                        return Swal.showValidationMessage(`
                        ${JSON.stringify(await response.json())}
                        `);
                    }
                    return response.json();
                } catch (error) {
                Swal.showValidationMessage(`
                    Request failed: ${error}
                `);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                console.log(result)
                if (result.isConfirmed) {
                    $('.todayCalories').html(`${result.value.date}`);
                    $('.todayCaloriesHTML').html(`${result.value.final}`);
                }
            });
        });
        $(document).on('click','.approvePopup',async(e)=>{
      
            var img = $(e.currentTarget).data('img');
            var datakey = $(e.currentTarget).data('key');
         
            const { value: formValues } = await Swal.fire({
                imageUrl: img,
                imageWidth: 400,
                imageHeight: 200,
                imageAlt: "Meal Picture",
                showCancelButton: true,
                confirmButtonText: "Approve",
                html: `
                    <h5>Meal Socres</h5>
                    <div style="display: flex;
                                align-items: center;
                                justify-content: center;">
                        <div class="form-group row mb-0">
                            <div class="rate text-center">
                                <input type="radio" id="star5" name="rate" value="5" />
                                <label for="star5" title="text">5 stars</label>
                                <input type="radio" id="star4" name="rate" value="4" />
                                <label for="star4" title="text">4 stars</label>
                                <input type="radio" id="star3" name="rate" value="3" />
                                <label for="star3" title="text">3 stars</label>
                                <input type="radio" id="star2" name="rate" value="2" />
                                <label for="star2" title="text">2 stars</label>
                                <input type="radio" id="star1" name="rate" value="1" />
                                <label for="star1" title="text">1 star</label>
                            </div>
                        </div>
                    </div>
                `,
                focusConfirm: false,
                allowOutsideClick: () => !Swal.isLoading(),
                preConfirm: async() => {
                    try {
                        var star = $('input[name="rate"]:checked').val();
                        if(star=='' || star==undefined){ 
                            star = 0;
                        }
                        var userDetailsURL = "{{ route('meal-picture-approve', ['uid' => ':id','status' => 'approve']) }}";
                            userDetailsURL = userDetailsURL.replace(':id', datakey);
                        console.log(userDetailsURL)
                        const githubUrl = userDetailsURL+'?star='+star;
                        const response = await fetch(githubUrl);
                        if (!response.ok) {
                            return Swal.showValidationMessage(`
                                ${JSON.stringify(await response.json())}
                            `);
                        }
                        return response.json();
                        
                    } catch (error) {
                        Swal.showValidationMessage(`
                            Request failed: ${error}
                        `);
                    }
                }
            });
            if (formValues) {
                if (formValues.status) {
                    Swal.fire({
                        position: "top-end",
                        title: `${formValues.message}`,
                        icon: formValues.status,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(()=>{
                        window.location.reload();
                    });
                }
            }
        });
    </script>
</body>

</html>