<!DOCTYPE html>
<html lang="en">

<head>
    <title>Meal Picture</title>
    @include('includes.header')
     <script src="{{asset('assets/js/bs/bootstrap.min.css')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.css')}}"></script> 

    <link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
    <style>
        .rate {
            float: left;
            height: 46px;
            padding: 0 10px;
        }
        .rate:not(:checked) > input {
            position:absolute;
            top:-9999px;
        }
        .rate:not(:checked) > label {
            float:right;
            width:1em;
            overflow:hidden;
            white-space:nowrap;
            cursor:pointer;
            font-size:30px;
            color:#ccc;
        }
        .rate:not(:checked) > label:before {
            content: '★ ';
        }
        .rate > input:checked ~ label {
            color: #ffc700;    
        }
        .rate:not(:checked) > label:hover,
        .rate:not(:checked) > label:hover ~ label {
            color: #deb217;  
        }
        .rate > input:checked + label:hover,
        .rate > input:checked + label:hover ~ label,
        .rate > input:checked ~ label:hover,
        .rate > input:checked ~ label:hover ~ label,
        .rate > label:hover ~ input:checked ~ label {
            color: #c59b08;
        }
    </style>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Meal Picture</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Meal Picture</h5>
                            <div class="row">
                                <div class="col-xl-5"></div>
                       
                                <div class="col-xl-3">
                                    <div >Date Range</div>
                                    <div id="reportrange" class="form-control float-left" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%">
                                        <i class="fa fa-calendar"></i>&nbsp;
                                        <span></span> <i class="fa fa-caret-down"></i>
                                    </div>
                                </div>
                                <div class="col-xl-3">
                                    <div >User</div>
                                    <select class="form-control getUser" >
                                        <option value="all">All users</option>
                                        @foreach($users as $user)
                                        <option value="{{$user->id}}">{{$user->name}} - {{$user->email}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-xl-1">
                                    <button class="mt-4 p-2 btn bg-gradient-dark" id="reloadData"><i class="fa fa-refresh"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                            <table id="getUserData" class="table table-striped" style="width:100%"></table>

                             
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    <script>
        $(document).on('change','#usertype',(res)=>{
            var type = res.target.value;
            if(type=="free"){
                $('.paidUserCheck').hide();
                $('#paid_plan').removeAttr('required');
            }
            if(type=="paid"){
                $('.paidUserCheck').show();
                $('#paid_plan').attr('required',true);
            }
            console.log(type)
        });

        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>
    <script src="{{asset('assets/js/bs/dataTables.js')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.js')}}"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>

    <script>
    
      
        $(document).on('change','#usertype',(res)=>{
            var type = res.target.value;
            if(type=="free"){
                $('.paidUserCheck').hide();
                $('#paid_plan').removeAttr('required');
            }
            if(type=="paid"){
                $('.paidUserCheck').show();
                $('#paid_plan').attr('required',true);
            }
            console.log(type)
        });

        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>

    <script type="text/javascript">
        var start = moment().subtract(29, 'days');
        var end = moment();
        var start_ = start.format('YYYY-MM-DD');
        var end_ = end.format('YYYY-MM-DD');
        $(function() {

         

            function cb(start, end) {
                $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
                start_ = $('#reportrange').data('daterangepicker').startDate.format('YYYY-MM-DD');
                end_ = $('#reportrange').data('daterangepicker').endDate.format('YYYY-MM-DD');
            }

            $('#reportrange').daterangepicker({
                startDate: start,
                endDate: end,
                ranges: {
                'Today': [moment(), moment()],
                'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
                'Last 7 Days': [moment().subtract(6, 'days'), moment()],
                'Last 30 Days': [moment().subtract(29, 'days'), moment()],
                'This Month': [moment().startOf('month'), moment().endOf('month')],
                'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
                'This Year': [moment().startOf('year'), moment().endOf('year')],
                'Last Year': [moment().subtract(1, 'year').startOf('year'), moment().subtract(1, 'year').endOf('year')]
                }
            }, cb);

            cb(start, end);

        });

        $(document).on('click','#reloadData',(res)=>{
            getData();
        });
        function getData(){
            $(document).ready(()=>{
                $('#getUserData').DataTable( {
                    "ajax": {
                        "url": "{{route('get-mealpick-datatable')}}",
                        "data": function ( d ) {
                                d.startDate=start_;
                                d.endDate=end_;
                                d.selectedUser=$('.getUser').val();
                            },
                            "dataSrc": function ( json ) {
                                return json.data;
                            }
                    },
                    fixedHeader: true,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    columns: [
                        { data: 'id',title:"#" },
                        { data: 'user',title:"Name",orderable:false,render:function (data,type,row){
                            if(data==null){
                                return '';
                            }
                            return data.name+'<br>'+data.email
                        }},

                        { data: 'file_path',title:"Meal Picture",render:function (data,type,row){
                            return `<img src="<?php echo env('APP_URL_STR'); ?>meal_pictures/`+data+`" height="50" width="50">
                                                <a href="<?php echo env('APP_URL_STR'); ?>meal_pictures/`+data+`" target="_blank"><button class="btn btn-sm bg-gradient-dark"><i class="feather icon-external-link"></i></button></a>`
                        } },
                        { data: 'star',title:"Stars",render:function (data,type,row){
                                if(row['is_approved']==1){
                                    return data;
                                }
                                return 'N/A';
                            }
                        },
                        { data: 'user_id',title:"Approval",render:function(data,type,row){
                            if(row['is_active']==1){
                               
                                if(row['is_approved']==1){
                                    return `<span class="badge bg-gradient-success">Approved</span>`;
                                }
                                if(row['is_approved']==0){
                                    if(row['need_retake']==1){
                                        return `<span class="badge bg-gradient-info">Re-Upload Requested</span>`;
                                    }
                                    if(row['need_retake']==0){
                                        return `<span class="badge bg-gradient-warning">Pending</span>`;
                                    }
                                }
                            }
                            if(row['is_active']==2){ return `<span class="badge bg-gradient-danger">Rejected</span>`; }
                            return '';
                        } },
                        { data: 'date',title:"Date" },
                        @if(permission('meal_picture','update') || permission('meal_picture','delete'))
                        { data: 'id',title:"Action",render:function(data,type,row){
                                var userDetailsURL = "{{ route('meal-picture-status', ['uid' => ':id','status' => ':status']) }}";
                                    userDetailsURL = userDetailsURL.replace(':id', data);
                                var approveURL = userDetailsURL.replace(':status', 'approve');
                                var rejectURL = userDetailsURL.replace(':status', 'reject');
                                var retakeURL = userDetailsURL.replace(':status', 'retake');
                                var btns = '';
                                // <a href="`+approveURL+`">
                                if(row['is_active']==1){
                                    if(row['is_approved']==1){
                                        // btns += `<b>Calories:</b>`+row['calories']+`&#160;&#160;<b>Protein:</b>`+row['protein']+`<br><b>Crabs:</b>`+row['crabs']+`&#160;&#160;<b>Fat:</b>`+row['fat'];
                                    }
                                    if(row['is_approved']==0){
                                        if(row['need_retake']==1){
                                            if({{permission('meal_picture','update')??0}}){
                                                btns += `<button class="btn btn-sm bg-gradient-success approvePopup" data-key="`+row['id']+`" data-img="<?php echo env('APP_URL_STR'); ?>meal_pictures/`+row['file_path']+`">Approve</button>`;
                                            }
                                            if({{(permission('meal_picture','delete')??0)??0}}){
                                                btns += `<a href="`+rejectURL+`">
                                                    <button class="btn btn-sm bg-gradient-danger">Reject</button>
                                                </a>`
                                            }
                                        }
                                        if(row['need_retake']==0){
                                            if({{permission('meal_picture','update')??0}}){
                                                btns += `
                                                    <button class="btn btn-sm bg-gradient-success approvePopup" data-key="`+row['id']+`" data-img="<?php echo env('APP_URL_STR'); ?>meal_pictures/`+row['file_path']+`">Approve</button>
                                                
                                                <a href="`+retakeURL+`">
                                                    <button class="btn btn-sm bg-gradient-info">Need Retake</button>
                                                </a>`
                                            }
                                            if({{(permission('meal_picture','delete')??0)??0}}){
                                                btns += `<a href="`+rejectURL+`">
                                                    <button class="btn btn-sm bg-gradient-danger">Reject</button>
                                                </a>`
                                            }
                                        }
                                    }
                                }
                                if(row['is_active']==2){
                                    btns += `<a href="`+retakeURL+`">
                                        <button class="btn btn-sm bg-gradient-info">Need Retake</button>
                                    </a>`
                                }
                                return btns;         
                        } },
                        @endif

                    ],
                    language: {
                        searchPlaceholder: "Search ..."
                    },
                    retrieve: true,
                }).ajax.reload();
            });
        }
        this.getData();

        $(document).on('click','.approvePopup',async(e)=>{
      
            var img = $(e.target).data('img');
            var datakey = $(e.target).data('key');
            const { value: formValues } = await Swal.fire({
                imageUrl: img,
                imageWidth: 400,
                imageHeight: 200,
                imageAlt: "Meal Picture",
                showCancelButton: true,
                confirmButtonText: "Approve",
                html: `
                    <h5>Meal Socres</h5>
                    <div style="display: flex;
                                align-items: center;
                                justify-content: center;">
                        <div class="form-group row mb-0">
                            <div class="rate text-center">
                                <input type="radio" id="star5" name="rate" value="5" />
                                <label for="star5" title="text">5 stars</label>
                                <input type="radio" id="star4" name="rate" value="4" />
                                <label for="star4" title="text">4 stars</label>
                                <input type="radio" id="star3" name="rate" value="3" />
                                <label for="star3" title="text">3 stars</label>
                                <input type="radio" id="star2" name="rate" value="2" />
                                <label for="star2" title="text">2 stars</label>
                                <input type="radio" id="star1" name="rate" value="1" />
                                <label for="star1" title="text">1 star</label>
                            </div>
                        </div>
                    </div>
                `,
                focusConfirm: false,
                allowOutsideClick: () => !Swal.isLoading(),
                preConfirm: async() => {
                    try {
                        var star = $('input[name="rate"]:checked').val();
                        if(star==''){ Swal.showValidationMessage(`Choose Star Scores`); 
                        } else {
                            var userDetailsURL = "{{ route('meal-picture-approve', ['uid' => ':id','status' => ':status']) }}";
                                userDetailsURL = userDetailsURL.replace(':id', datakey);
                            var approveURL = userDetailsURL.replace(':status', 'approve');

                            const githubUrl = approveURL+'?star='+star;
                            const response = await fetch(githubUrl);
                            if (!response.ok) {
                                return Swal.showValidationMessage(`
                                    ${JSON.stringify(await response.json())}
                                `);
                            }
                            return response.json();
                        }
                    } catch (error) {
                        Swal.showValidationMessage(`
                            Request failed: ${error}
                        `);
                    }
                }
            });
            if (formValues) {
                if (formValues.status) {
                    Swal.fire({
                        position: "top-end",
                        title: `${formValues.message}`,
                        icon: formValues.status,
                        showConfirmButton: false,
                        timer: 1500
                    }).then(()=>{
                        this.getData();
                    });
                }
            }
        });
    </script>
</body>

</html>