<!DOCTYPE html>
<html lang="en">

<head>
    <title>Admin Roles</title>
    @include('includes.header')
    <style>
        .rolelist:nth-of-type(even) {
            background-color: #e1e1e1;
        }
    </style>
</head>

<body>
    @include('includes.flash-sms')
    @include('includes.navbar')
    @include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">

                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i
                                            class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a href="{{route('admin-roles')}}">Admin Roles</a></li>
                                <li class="breadcrumb-item"><a>Add a new Role</a></li>
                            </ul>

                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->

            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Add a new Role</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <form action="{{route('save-role')}}" method="post">
                                @csrf
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="col-md-6 col-12 col-lg-4">
                                            <div class="form-group">
                                                <label for="myname">Name <span class="text-danger">*</span></label>
                                                <input type="text" class="form-control" name="name" id="myname" required
                                                    placeholder="Enter name">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="col-md-12">
                                            <h6>Permissions
                                                <button type="button" class="btn btn-sm bg-gradient-info pr checkAll"
                                                    style="font-size:12px">Select All</button>
                                                <!-- <button class="btn btn-sm bg-gradient-danger uncheckAll" style="font-size:12px">Deselect All</button> -->
                                            </h6>
                                            <hr>
                                            @foreach($permission as $list)
                                                <div class="p-2 rolelist">
                                                    <label
                                                        style="text-transform: capitalize">{{str_replace('_', ' ', $list->name)}}</label>&emsp;<small><a
                                                            style="text-decoration: underline;"
                                                            onclick="selectDataCheck('{{$list->name}}')">Select
                                                            All</a></small><br>
                                                    @foreach(([]) as $sublist)
                                                        <div class="form-check form-check-inline ">
                                                            <input class="form-check-input inp{{$list->name}}" type="checkbox"
                                                                id="{{$list->name}}_{{$sublist}}" name="permissions[]"
                                                                value="{{$list->name}}^09N74^{{$sublist}}">
                                                            <label class="form-check-label" style="text-transform: capitalize"
                                                                for="{{$list->name}}_{{$sublist}}">{{str_replace('_', ' ', $sublist)}}</label>
                                                        </div>
                                                    @endforeach
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>

                                </div>
                                <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->

        </div>
    </div>
    @include('includes.footer')


    <script>
        $(document).on('click', '.checkAll', () => {
            $('input[type=checkbox]').each((e, val) => {
                $(val).prop('checked', 'true');
            });
        });
        $(document).on('click', '.uncheckAll', () => {
            $('input[type=checkbox]').each((e, val) => {
                $($(val)[0]).removeAttr('checked');
            });
        });
        function selectDataCheck(req) {
            $('.inp' + req).each((e, val) => {
                $(val).prop('checked', 'true');
            });
        }
    </script>
</body>

</html>