<!DOCTYPE html>
<html lang="en">

<head>
    <title>Assigned Trainee Users</title>
    @include('includes.header')
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.css" />
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(auth()->user()->role!='user' && permission('admin_users','trainee')) 
                                @if(count($isolated_trainee)>0) <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Assign New Trainee</button>@endif
                            @endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                @if(auth()->user()->role!='user' && permission('admin_users','trainee')) 
                                    <li class="breadcrumb-item"><a href="{{route('admin-users')}}">Admin Users</a></li>
                                @endif
                                <li class="breadcrumb-item"><a >Assigned Trainee Users</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Assigned Trainee Users</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Name</th>
                                            <th>Email</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($user as $list)
                                        <tr>
                                            <td>{{$list->name}}</td>
                                            <td>{{$list->email}}</td>
                                            <td>@if($list->status==1)
                                                    <span class="badge bg-gradient-success">Active</span>
                                                @elseif($list->status==0)
                                                    <span class="badge bg-gradient-danger">Disabled</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if(permission('app_users','sts')) 
                                                <a href="{{route('app-users-sts',['id'=>$list->id])}}" >
                                                    <button class="btn btn-sm bg-gradient-dark" title="View ">View</button>
                                                </a>
                                                @endif
                                                @if(auth()->user()->role!='user' && permission('admin_users','trainee')) 
                                                <a href="{{route('unassign-users',['id'=>$iod,'ids'=>base64_encode($list->id)])}}">
                                                    <button class="btn btn-sm bg-gradient-danger" title="Remove ">Unassign</button>
                                                </a>
                                                @endif
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="4" class="text-center">Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $user->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
               
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Assign New Trainee</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
           
                <div class="modal-body">
                
                <form action="{{route('add-assigned-users',['id'=>$iod])}}" id="storeUser" method="post">
                    @csrf
                     <div class="row">
                      
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="assignUser">Users <span class="text-danger">*</span></label>
                                <select id="assignUser" name="assignuser[]" class="form-control selectpicker" multiple data-live-search="true" required>
                                    @foreach($isolated_trainee as $list)
                                    <option value="{{$list->id}}">{{$list->name}} - {{$list->email}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    
                    </div>
              
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>

    <script>
        $('#assignUser').selectpicker();
    </script>
</body>

</html>