<!DOCTYPE html>
<html lang="en">

<head>
    <title>Recipe Ingredients</title>
    @include('includes.header')
        <script src="{{asset('assets/js/bs/bootstrap.min.css')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.css')}}"></script> 
    <style>
       
        .iconu{
            font-size:22px;
        }
        .iconu.nonveg{
           color:indianred;
        }
        .iconu.fa-egg{
           color:orange;
        }
        .iconu.fa-leaf{
           color:green;
        }
    </style>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                                @if(permission('recipe_list','create'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a Recipe Ingredients</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Recipe Ingredients</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Recipe Ingredients</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table id="getUserData" class="table table-striped" style="width:100%"></table>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Recipe Ingredients</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form action="{{route('store-recipe-ingredients')}}"  method="post" enctype='multipart/form-data'>
                    <div class="modal-body ">
                        <div class="row">
                                <div class="col-md-12">
                                    @csrf
                                    <div class="row">
                                        <div class="form-group col-6">
                                            <label for="name_p">Name</label>
                                            <input type="text" class="form-control" id="name_p" name="name" placeholder="Enter name" required>
                                        </div>
                                        <div class="form-group col-6">
                                            <label for="foodtype">Type</label>
                                            <select class="form-control" id="foodtype" name="foodtype" required>
                                            <option value="" selected disabled>Select Type</option>
                                                <option value="veg">Veg</option>
                                                <option value="non-veg">Non-Veg</option>
                                                <option value="egg">Contains Egg</option>
                                                <option value="healthy_fast_food">Healthy Fast Foods</option>
                                                <option value="shakes_smoothies">Shakes & Smoothies</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="row">
                                        <div class="form-group col-6">
                                            <label for="calories">Calories</label>
                                            <input type="text" class="form-control" id="calories" name="calories" placeholder="Enter calories" required>
                                        </div>
                                        <div class="form-group col-6">
                                            <label for="protein">Protein</label>
                                            <input type="text" class="form-control" id="protein" name="protein" placeholder="Enter protein" required>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="form-group col-6">
                                            <label for="crabs">Crabs</label>
                                            <input type="text" class="form-control" id="crabs" name="crabs" placeholder="Enter crabs" required>
                                        </div>
                                        <div class="form-group col-6">
                                            <label for="fat">Fat</label>
                                            <input type="text" class="form-control" id="fat" name="fat" placeholder="Enter fat" required>
                                        </div>
                                    </div>
                                    <label for="qty">Qty <small>(For decoding calories,protein,crabs,fat)</small></label>
                                    <div class="form-group row">
                                        <div class="col-6">
                                            <input type="text" class="form-control" id="qty" name="qty" required placeholder="Enter qty" required>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <select class="form-control" id="type" name="type" required>
                                                    <option value="" selected disabled>Measurement Type</option>
                                                    <option value="gm">gm</option>
                                                    <option value="kg">kg</option>
                                                    <option value="ml">ml</option>
                                                    <option value="ltr">ltr</option>
                                                    <option value="ltr">ltr</option>
                                                    <option value="qty">qty</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea class="form-control" id="description" name="description" placeholder="Enter description"></textarea>
                                    </div>
                                
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                            </div>
                    </div>
                </form>
            </div>
        </div>
    </div> 

    <script src="{{asset('assets/js/bs/dataTables.js')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.js')}}"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
    <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
    <script type="text/javascript">
    
        $(document).on('click','#reloadData',(res)=>{
            getData();
        });
        function getData(){
            $(document).ready(()=>{
                $('#getUserData').DataTable( {
                    "ajax": {
                        "url": "{{route('recipe-ingredients-datatable')}}",
                        "data": function ( d ) {
                            },
                            "dataSrc": function ( json ) {
                                return json.data;
                            }
                    },
                    fixedHeader: true,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    columns: [
                        { data: 'id',title:"#",
                            render:function(data,type,row){
                                var html = ``;
                                    //  <button class="btn btn-sm bg-gradient-success">Edit</button>
                                    html = `
                                            @if(permission('recipe_list','update') || permission('recipe_list','delete'))
                                                
                                                    @if(permission('recipe_list','update'))
                                                        
                                                    @endif
                                                    @if(permission('recipe_list','delete'))
                                                        <form action="{{route('delete-recipe-ingredients')}}" method="post" >
                                                            @csrf
                                                            @method('PUT')
                                                            <input type="hidden" name="id" value="`+row['id']+`">
                                                            <button class="btn btn-sm bg-gradient-danger" type="submit"><i class="feather icon-trash-2"></i></button>
                                                        </form>
                                                    @endif
                                                                                
                                            @endif `;
                                
                                return html;
                            }
                        },
                        { data: 'name',title:"Name",orderable:true,
                            render:function (data,type,row){
                                var resp = data;
                                if(row['status']==1){
                                    resp += '<br><span class="badge badge-success">Active</span>';
                                } else if(row['status']==0){
                                    resp += '<br><span class="badge badge-success">Inactive</span>';
                                } else if(row['status']==2){
                                    resp += '<br><span class="badge badge-success">Draft</span>';
                                }
                                return resp;
                            }
                        },
                        { data: 'description',title:"Description" },
                        { data: 'foodtype',title:"Food Type",
                            render:function (data,row){
                                var resp = "";
                                if(data=='veg'){
                                    resp = '<i class="fa-solid fa-leaf iconu"></i>';
                                } else if(data=='non-veg'){
                                    resp = '<i class="fa-solid fa-drumstick-bite iconu nonveg"></i>';
                                } else if(data=='egg'){
                                    resp = '<i class="fa-solid fa-egg iconu"></i>';
                                }
                                return resp;
                            }
                        },
                        { data: 'calories',title:"CALORIES" },
                        { data: 'protein',title:"PROTIEN" },
                        { data: 'crabs',title:"CRABS" },
                        { data: 'fats',title:"FAT" },
                        { data: 'qty',title:"QTY",orderable:false,
                            render:function (data,type,row){
                                return data+" "+row['type'];
                            }
                        }
                    ],
                    language: {
                        searchPlaceholder: "Search ..."
                    },
                    retrieve: true,
                }).ajax.reload();
            });
        }
        this.getData();
    </script>
</body>

</html>