<!DOCTYPE html>
<html lang="en">

<head>
    <title>Recipe List</title>
    @include('includes.header')
    <style>
       
        .iconu{
            font-size:22px;
        }
        .iconu.nonveg{
           color:indianred;
        }
        .iconu.fa-egg{
           color:orange;
        }
        .iconu.fa-leaf{
           color:green;
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/css/bootstrap-select.css" />
    <link rel="stylesheet" href="https://code.jquery.com/ui/1.14.0/themes/base/jquery-ui.css">
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                                @if(permission('recipe_list','create'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a Recipe</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Recipe List</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Recipe List</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Name</th>
                                            <th>Type</th>
                                            <th>Description</th>
                                            <th>Ingredients</th>
                                            @if(permission('recipe_list','update') || permission('recipe_list','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($listing as $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{{$list->name}}</td>
                                            <td>@if($list->type=='veg')
                                                    <i class="fa-solid fa-leaf iconu"></i>
                                                @elseif($list->type=='non-veg')
                                                    <i class="fa-solid fa-drumstick-bite iconu nonveg"></i>
                                                @elseif($list->type=='egg')
                                                    <i class="fa-solid fa-egg iconu"></i>
                                                @endif
                                            </td>
                                            <td>{!!wordwrap($list->description,70,"<br>") !!}</td>
                                            <td>@foreach($list->ingredient as $index=> $list_a) {{$index+1}}: {{$list_a}}<br> @endforeach</td>
                                           
                                            @if(permission('recipe_list','update') || permission('recipe_list','delete'))
                                            <td>
                                                @if(permission('recipe_list','update'))
                                                <!-- <a >
                                                    <button class="btn btn-sm bg-gradient-success">Edit</button>
                                                </a> -->
                                                @endif
                                                @if(permission('recipe_list','delete'))
                                                    <form action="{{route('delete-recipe-list')}}" method="post" >
                                                        @csrf
                                                        @method('PUT')
                                                        <input type="hidden" name="id" value="{{$list->id}}">
                                                        <button class="btn btn-sm bg-gradient-danger" type="submit"><i class="feather icon-trash-2"></i></button>
                                                    </form>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="9" class="text-center"> Empty</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $listing->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Recipe </h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <form action="{{route('store-recipe-list')}}"  method="post" enctype='multipart/form-data'>
                    <div class="modal-body">
                        <div class="row">
                                <div class="col-md-12">
                                    @csrf
                                    <div class="row">
                                        <div class="form-group col-6">
                                            <label for="name_p">Name</label>
                                            <input type="text" class="form-control" id="name_p" name="name" placeholder="Enter name" required>
                                        </div>
                                        <div class="form-group col-6">
                                            <label for="type">Type</label>
                                            <select class="form-control" id="type" name="type" required>
                                                <option value="" selected disabled>Select Type</option>
                                                <option value="veg">Veg</option>
                                                <option value="non-veg">Non-Veg</option>
                                                <option value="egg">Contains Egg</option>
                                                <option value="healthy_fast_food">Healthy Fast Foods</option>
                                                <option value="shakes_smoothies">Shakes & Smoothies</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <label for="description">Description</label>
                                        <textarea class="form-control" id="description" name="description" placeholder="Enter description"></textarea>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="assignUser">Ingredients <span class="text-danger">*</span></label>
                                            <select id="assignUser" class="form-control selectpicker" multiple data-live-search="true" required>
                                                @foreach($isolated_ingredients as $list)
                                                <option value="{{$list}}">{{$list->name}} - {{$list->email}}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="add-on-html " id="sortable"> </div>
                                   
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                                <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                            </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-select/1.13.1/js/bootstrap-select.min.js"></script>
    <script src="https://code.jquery.com/ui/1.14.0/jquery-ui.js"></script>

    <script>
        $('#assignUser').selectpicker();
        $('#assignUser').change(function () {
            var selectedItem = $('#assignUser').val();
            var list = '<label>Ingredients Steps</label>';
            selectedItem.forEach(element => {
                var js_e = JSON.parse(element);
                list +=
                `<div class="row ui-state-default" style="display: flex;align-items: center;    border: 1px solid #e2e2e2;">

                <div class="form-group col-12 mb-1 mt-1">
                    `+js_e.name+`
                    <input type="hidden" value="`+js_e.id+`" name="step_id[]">
                     <input type="hidden" value="`+js_e.name+`" name="step_name[]">
                </div>
                <div class="form-group col-1 mb-1 mt-1">
                    <i class="fa fa-sort" aria-hidden="true"></i>
                </div>
                <div class="form-group mb-1 mt-1 p-0 col-2">
                    <label>Qty</label>
                    <input type="number" class="form-control" id="step_qty" name="step_qty[]" placeholder="Enter Qty" required>
                </div>
                  <div class="form-group mb-1 mt-1 p-0 col-3">
                    <label>Type</label>
                    <select class="form-control" id="step_type" name="step_type[]" required>
                        <option value="" selected disabled>Measurement Type</option>
                        <option value="gm">gm</option>
                        <option value="kg">kg</option>
                        <option value="ml">ml</option>
                        <option value="ltr">ltr</option>
                        <option value="qty">qty</option>
                    </select>
                </div>
                  <div class="form-group mb-1 mt-1 p-0 col-6">
                    <label>Note</label>
                    <input type="text" class="form-control" id="step_note" name="step_note[]" placeholder="Enter Note" >
                </div>
                </div>`;
            });
            $('.add-on-html').html(list)
        });

        $( function() {
            $( "#sortable" ).sortable();
        } );
    </script>

   
</body>

</html>