<!DOCTYPE html>
<html lang="en">

<head>
    <title>Admin Users</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('admin_users','create')) <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New User</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Admin Users</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Admin Users</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>First Name</th>
                                            <th>Email</th>
                                            <th>Role</th>
                                            <th>Status</th>
                                            @if(permission('admin_users','update') || permission('admin_users','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($user as $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>{{$list->name}}</td>
                                            <td>{{$list->email}}</td>
                                            <td>
                                                @if($list->role=='user')<span class="badge bg-gradient-info">Trainer</span>
                                                @elseif($list->role=='admin')<span class="badge bg-gradient-dark">Admin</span>
                                                @elseif($list->role=='subadmin')<span class="badge bg-gradient-secondary">Sub Admin</span>
                                                @else<span class="badge bg-gradient-secondary">{{$list->role}}</span>
                                                @endif
                                            </td>
                                            <td>@if($list->status==1)
                                                    <span class="badge bg-gradient-success">Active</span>
                                                @elseif($list->status==0)
                                                    <span class="badge bg-gradient-danger">Disabled</span>
                                                @endif
                                            </td>
                                            @if(permission('admin_users','update') || permission('admin_users','delete'))
                                            <td>
                                                @if(permission('admin_users','update'))
                                                    @if($list->role=='user' && permission('admin_users','trainee'))
                                                        <a href="{{route('assigned-users',['id'=>$list->id])}}">
                                                            <button class="btn btn-sm bg-gradient-dark" title="List Assigned Trainee"><i class="feather icon-list"></i></button>
                                                        </a>
                                                    @endif
                                                    <button class="btn btn-sm bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive{{$list->id}}" title="Edit Details"><i class="feather icon-edit"></i></button>
                                                    <a href="{{route('users-disable',['id'=>$list->id])}}" title="Enable/Disable Account" onclick="return confirm('Change Status?')">
                                                        <button class="btn btn-sm bg-gradient-secondary"><i class="feather icon-slash"></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-warning" title="Change Password"><img height="18" width="15" onclick="changePassword({{$list->id}})" src="{{asset('assets/cust-icons/key.svg')}}"></button>
                                                @endif
                                                @if(permission('admin_users','delete'))
                                                    <a href="{{route('app-users-delete',['id'=>$list->id])}}" title="Delete Account " onclick="return confirm('Are you sure? Delete User')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="4"> Empty</td>
                                        </tr>
                                        @endforelse
                                        
                                    </tbody>
                                </table>
                                {{ $user->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
               
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
           
                <div class="modal-body">
                
                    <form action="{{route('store-admin-user')}}" id="storeUser" method="post">
                        @csrf
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="myname">Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="myname" id="myname" required placeholder="Enter name">
                                </div>
                                <div class="form-group">
                                    <label for="my_email">Email address <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="my_email" id="my_email" required aria-describedby="emailHelp" placeholder="Enter email">
                                </div>
                                <div class="form-group">
                                    <label for="password">Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" id="password" required placeholder="Password">
                                </div>
                                <div class="form-group">
                                    <label for="confirm_password">Confirm Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="confirm_password" id="confirm_password" required placeholder="Confirm Password">
                                    <span class="err-msg text-danger"></span>
                                </div>
                                
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date of Birth <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" max="{{date('Y-m-d',strtotime('-1 year'))}}" name="dob" required>
                                </div>
                                <div class="form-group">
                                    <label for="userRole">Role <span class="text-danger">*</span></label>
                                    <select class="form-control" id="userRole" name="role" required>
                                        <option value="" selected disabled>Select Role</option>
                                        @foreach($role as $list) <option value="{{$list->name}}">{{$list->name=="user"?'User (Trainer)':$list->name}}</option> @endforeach
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Mobile Number <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" name="mobile_no" required placeholder="Mobile no.">
                                </div>
                            </div>
                        
                        </div>
                
                        <div class="modal-footer">
                            <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @forelse($user as $list)
    <div id="exampleModalLive{{$list->id}}" class="modal fade" tabindex="1" role="dialog" aria-labelledby="exampleModalLive{{$list->id}}Label" aria-hidden="true">
        <div class="modal-dialog" role="document1">
            <div class="modal-content">
               
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive{{$list->id}}Label">Edit User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
           
                <div class="modal-body">
                
                <form action="{{route('update-admin-user')}}" id="storeUser{{$list->id}}" method="post">
                    @csrf
                     <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="myname">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="myname" value="{{$list->name}}" required placeholder="Enter name">
                                <input type="hidden" class="form-control" name="id"  value="{{$list->id}}" >
                            </div>
                            <div class="form-group">
                                <label for="my_email">Email address <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="my_email" value="{{$list->email}}" required aria-describedby="emailHelp" placeholder="Enter email">
                            </div>
                            <div class="form-group">
                                <label for="exampleFormControlTextarea1">Mobile Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" value="{{$list->phone}}" name="mobile_no" required placeholder="Mobile no.">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Date of Birth <span class="text-danger">*</span></label>
                                <input type="date"  value="{{$list->dob}}" class="form-control" max="{{date('Y-m-d',strtotime('-1 year'))}}" name="dob" required>
                            </div>
                            <div class="form-group">
                                <label for="userRole">Role <span class="text-danger">*</span></label>
                                <select class="form-control"  name="role" required>
                                    <option value="" selected disabled>Select Role</option>
                                    @foreach($role as $slist) 
                                    <option value="{{$slist->name}}"  @if($list->role==$slist->name) selected @endif >
                                        {{$slist->name=="user"?'User (Trainer)':$slist->name}}</option> @endforeach
                                </select>
                            </div>

                        </div>
                    
                    </div>
              
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        </div>
    </div>
    @endforeach
  
    <script>

        function changePassword(id){
            Swal.fire({
                title: "Enter new password",
                input: "password",
                inputLabel: "New Password",
                inputPlaceholder: "Enter new password",
                inputAttributes: {
                    maxlength: "10",
                    autocapitalize: "off",
                    autocorrect: "off"
                },
                showCancelButton: true,
                confirmButtonText: "Submit",
                showLoaderOnConfirm: true,
                preConfirm: async (login) => {
                    if(login==""){
                        return Swal.showValidationMessage(`Enter Password`);
                    }
                    try {
                    const response = await fetch('{{route("users-password")}}',{
                        headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                        },
                        method: "POST",
                        body: JSON.stringify({id:id,password:login,_token:$("input[name=_token]").val()})
                    });
                    if (!response.ok) {
                        return Swal.showValidationMessage(`
                        ${JSON.stringify(await response.json())}
                        `);
                    }
                    return response.json();
                    } catch (error) {
                    Swal.showValidationMessage(`
                        Request failed: ${error}
                    `);
                    
                    }
                },
                allowOutsideClick: () => !Swal.isLoading()
                }).then((result) => {
                if (result.isConfirmed) {
                    ToastK.fire({
                        icon: result.value.type ,
                        title: result.value.message 
                    });
                }
            });
        }
        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>
</body>

</html>