<!DOCTYPE html>
<html lang="en">

<head>
    <title>Workout {{$workoutplan->title}}</title>
    @include('includes.header')
    <style>
        .loader {
            height: 80px;
            aspect-ratio: 1;
            display: grid;
        }
        .loader:before,
        .loader:after {
            content: "";
            --c:no-repeat linear-gradient(#000 0 0);
            background: var(--c), var(--c);
            background-size: 25% 50%;
            animation: l4 1.5s infinite linear;
        }
        .loader:after {
            transform: scale(-1);
        }
        @keyframes l4 {
            0%,
            10%  {background-position:33.4% 100%,66.6% 100%}
            40%  {background-position:33.4% 0,100% 100%}
            70%  {background-position:0 100%,66.6% 0}
            100% {background-position:33.4% 100%,66.6% 100%}
        } 
    </style>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" />
    <style>
        .select2-dropdown{
            z-index:99999 !important;
        }
    </style>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('workout_days','update'))
                                <button class="m-b-10 btn bg-gradient-dark pr" data-toggle="modal" data-target="#importWorkout">Import Workout Days</button>
                                <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Workout Days</button>
                            @endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a href="{{route('workout_plans')}}">Workout Plans</a></li>
                                <li class="breadcrumb-item"><a >{{$workoutplan->title}}</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="row">
                        <div class="card mb-3 col-12 col-sm-6 col-md-4 col-lg-4" >
                            <div class="row g-0">
                                <div class="col-md-4">
                                    <img src="{{env('APP_URL_STR').'workout/'}}{{$workoutplan->image}}" class="img-fluid rounded-start" alt="...">
                                </div>
                                <div class="col-md-8">
                                    <div class="card-body">
                                        <h5 class="card-title">{{$workoutplan->title}}</h5>
                                        <p class="card-text">
                                            @if($workoutplan->video_type=="youtube") <i class="fa fa-youtube-play text-danger" style="font-size:20px"></i> @endif
                                            Video ID: {{$workoutplan->video_url}}
                                        </p>
                                        <p>Assigned to: {{$workoutplan->user?->name ?? "All Users"}}<br>{{$workoutplan->user?->email}}</p>
                                        <p class="card-text">
                                            @if($workoutplan->is_paid==0)
                                            <span class="badge bg-gradient-danger">Not Paid</span>
                                            @else
                                            <span class="badge bg-gradient-success">Paid</span>
                                            @endif
                                            @if($workoutplan->status==1)
                                                <span class="badge bg-gradient-success">Active</span>
                                            @elseif($workoutplan->status==0)
                                                <span class="badge bg-gradient-danger">Inactive</span>
                                            @elseif($workoutplan->status==2)
                                                <span class="badge bg-gradient-warning">Draft</span>
                                            @endif
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class=" md-3 col-12 col-sm-6 col-md-4 col-lg-3">
                            <iframe width="100%" height="100%" class="editVideourl"
                                src="https://www.youtube.com/embed/{{$workoutplan->video_url}}">
                            </iframe>
                        </div>
                    </div>
                    <div class="accordion" id="accordionExample">
                        @forelse($workoutplan->workout_days as $idx=> $plan_days)
                            <div class="card">
                                <div class="card-header" id="heading{{$idx}}" style="    background: #eee4ff;">
                                    <img src="{{env('APP_URL_STR').'workout/'}}{{$plan_days->image}}" class="float-left" height="70" width="70">
                                    <h2 class="mb-0 float-left w-50">
                                        <button class="btn btn-link w-100  text-left @if($idx==0) collapsed @endif" type="button" data-toggle="collapse" data-target="#collapseOne{{$idx}}" @if($idx==0) aria-expanded="true" @else aria-expanded="false" @endif aria-controls="collapseOne{{$idx}}">
                                            {{$plan_days->title}}
                                            @if($plan_days->status==1)
                                                <span class="badge bg-gradient-success">Active</span>
                                            @elseif($plan_days->status==0)
                                                <span class="badge bg-gradient-danger">Inactive</span>
                                            @elseif($plan_days->status==2)
                                                <span class="badge bg-gradient-warning">Draft</span>
                                            @endif
                                        </button>
                                    </h2>
                                    <div class="float-right">
                                        @if(permission('workout_plan_days','update') || permission('workout_plan_days','delete'))
                                            @if(permission('workout_plan_days','update'))
                                                @if(permission('workout_days','read'))
                                                <button class="btn btn-sm bg-gradient-dark mr-1 editModel" data-toggle="collapse" data-target="#collapseOne{{$idx}}" @if($idx==0) aria-expanded="true" @else aria-expanded="false" @endif aria-controls="collapseOne{{$idx}}" style="float:left" ><i class="feather icon-list"></i></button>
                                                @endif
                                                <form style="float:left" action="{{ route('status-workout_plan_days', ['id' => $plan_days->id]) }}" method="post" onsubmit="return confirm('Change Status')">
                                                    @csrf
                                                    @method('PUT')
                                                    <button class="btn btn-sm bg-gradient-warning mr-1"><i class="feather icon-refresh-cw"></i></button>
                                                </form>
                                                <button class="btn btn-sm bg-gradient-info mr-1 editModel" style="float:left"  data-toggle="modal" data-target="#exampleModalLiveq" data-array="{{base64_encode(json_encode($plan_days))}}"><i class="feather icon-edit" data-array="{{base64_encode(json_encode($plan_days))}}"></i></button> 
                                            @endif
                                            @if(permission('workout_plan_days','delete'))
                                                <form style="float:left" action="{{ route('delete-workout_plan_days', ['id' => $plan_days->id]) }}" method="post" onsubmit="return confirm('Are you sure? Delete')">
                                                    @csrf
                                                    @method('PUT')
                                                    <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                </form>
                                            @endif
                                        
                                        @endif
                                    </div>
                                </div>

                                <div id="collapseOne{{$idx}}" class="collapse  @if($idx==0) show @endif" aria-labelledby="heading{{$idx}}" data-parent="#accordionExample">
                                    <div class="card-body">
                                        @if(permission('workout_days','update'))
                                            <button class="m-b-10 btn bg-gradient-success pr float-right" data-toggle="modal" data-target="#exampleModalLiveEdit{{$idx}}">Add a New Exercise</button>
                                        @endif
                                        <table class="table table-striped">
                                            <tr>
                                                <th>Image</th>
                                                <th>Exercise Type</th>
                                                <th>Title</th>
                                                <th>No of Set</th>
                                                <th>No of Reps</th>
                                                <th>Video URL & Type</th>
                                                <th>Status</th>
                                                <th>Action</th>                                        
                                            </tr>
                                            @forelse($plan_days->workout_exersice as $list)
                                                <tr>
                                                    <td><img src="{{env('APP_URL_STR').'workout/'}}{{$list->image}}" height="70" width="70"></td>
                                                    <td>{{ucwords($list->exersice_type)}}</td>
                                                    <td>{{$list->title ?? "N/A"}}</td>
                                                    <td>{{$list->no_of_sets}}</td>
                                                    <td>{{$list->no_of_reps}}</td>
                                                    <td>
                                                        @if($list->video_type=="youtube")
                                                            <a href="https://www.youtube.com/embed/{{$list->video_url}}" target="_blank">
                                                                {{$list->video_url}}<button class="btn btn-sm  mr-1"><i class="fa fa-youtube-play text-danger" style="font-size:20px"></i></button>
                                                            </a>
                                                        @else
                                                            {{$list->video_type}} {{$list->video_url}}
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($list->status==0)<span class="badge bg-gradient-danger">Inactive</span>@endif
                                                        @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                        @if($list->status==2)<span class="badge bg-gradient-warning">Draft</span>@endif
                                                    </td>
                                                    <td>
                                                        @if(permission('workout_days','update'))
                                                            <form style="float:left" action="{{route('status-workout_days',['id'=>$list->id])}}" method="post" onsubmit="return confirm('Change Status')">
                                                                @csrf
                                                                @method('PUT')
                                                                <button class="btn btn-sm bg-gradient-dark mr-1"><i class="feather icon-refresh-cw"></i></button>
                                                            </form>
                                                            
                                                        @endif
                                                        @if(permission('workout_days','delete'))
                                                            <form style="float:left" action="{{route('delete-workout_days',['id'=>$list->id])}}" method="post" onsubmit="return confirm('Are you sure? Delete')">
                                                                @csrf
                                                                @method('PUT')
                                                                <button class="btn btn-sm bg-gradient-danger mr-1"><i class="feather icon-trash-2"></i></button>
                                                            </form>
                                                        @endif
                                                    </td>                                        
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="7">No Exercise Added!</td>                                       
                                                </tr>
                                            @endforelse
                                        </table>
                                    </div>
                                </div>
                            </div>
                        @empty

                        @endforelse
                 
                    </div>
                 
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    {{-- <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Workout Days</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save_workout_days')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="workoutplanday">Workout Plan Day </label><br>
                                {{$workoutplan->title}}
                                <input class="form-control " type="hidden"  id="workoutplanday" value="{{$workoutplan->uuid}}" name="workoutplanday" >
                            </div>
                            <div class="afterWorkoutChoose" >
                                <div class="form-group">
                                    <label for="exercise_type">Exercise Type <span class="text-danger">*</span></label>
                                    <select class="form-control" id="exercise_type" name="exercise_type" required>
                                        <option value="" selected disabled>Select Exercise Type</option>
                                        <option value="strength">STRENGTH </option>
                                        <option value="endurance">ENDURANCE  </option>
                                        <option value="bodyweight">BODYWEIGHT </option>
                                    </select>
                                </div>
                                <div class="afterWorkoutTypeChoose" style="display:none">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="Title" name="title" required>
                                    </div>
                                    <div class="form-group strengthField">
                                        <label for="exercise_machine">Strength Machines <span class="text-danger">*</span></label>
                                        <select class="form-control" id="exercise_machine" name="exercise_machine" required>
                                            <option value="" selected disabled>Select Exercise Type</option>
                                            @foreach($exercise_machines as $list_m)<option value="{{$list_m->uuid}}" >{{$list_m->name}}</option>@endforeach
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                        <input type="file" class="form-control" name="image" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="videotype">Video Type <span class="text-danger">*</span></label>
                                        <select class="form-control" id="videotype" name="videotype" required>
                                            <option value="" selected disabled>Select Video Type</option>
                                            <option value="youtube" selected>Youtube</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="videourl">Video URL <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="videourl" id="videourl" required placeholder="Enter url">
                                    </div>
                                    <div class="form-group strengthField enduranceField bodyweightField">
                                        <label for="exampleInputEmail1">No of Reps <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="No of Reps" name="no_of_reps" >
                                    </div>
                                    <div class="form-group strengthField enduranceField bodyweightField">
                                        <label for="exampleInputEmail1">No of Sets <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="No of Sets" name="no_of_sets" >
                                    </div>
                                    <div class="form-group strengthField ">
                                        <label for="exampleInputEmail1">Default Weight <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="Default Weight" name="default_weight" >
                                    </div>
                                    <div class="form-group strengthField enduranceField">
                                        <label for="exampleInputEmail1">Take Time <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="Take Time" name="take_time" >
                                    </div>
                                    <div class="form-group">
                                        <label for="myname">Is Rest After <span class="text-danger">*</span></label>
                                        <div class="form-group">
                                            <span style="padding: 0px 25px">
                                                <input type="radio" name="ispaid" id="ispaidyes" value="yes" required >
                                                <label for="ispaidyes">Yes</label>
                                            </span>
                                            <span  style="padding: 0px 25px">
                                                <input type="radio" name="ispaid" id="ispaidno" value="no" checked required >
                                                <label for="ispaidno">No</label>
                                            </span>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div> --}}

    {{-- Add New Day --}}
     <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Workout Plan Days</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save_workout_plan_days')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                           
                            <div class="form-group">
                                <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="Title" name="title" required>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="image" >
                            </div>
                            <div class="form-group">
                                <label for="myname">Is User Spacific <span class="text-danger">*</span></label>
                                <div class="form-group" >
                                    <span style="padding: 0px 25px">
                                        <input type="radio" name="is_user_selected" onclick="return false;" value="yes" id="is_user_selectedyes" @if(!empty($workoutplan->user)) checked @endif required >
                                        <label for="is_user_selectedyes">Yes</label>
                                    </span>
                                    <span  style="padding: 0px 25px">
                                        <input type="radio" name="is_user_selected" onclick="return false;" value="no" id="is_user_selectedno" @if(empty($workoutplan->user)) checked @endif required >
                                        <label for="is_user_selectedno">No</label>
                                    </span>
                                </div>
                            </div>
                           
                            <div class="form-group allUserSelect"  @if(empty($workoutplan->user)) style="display:none" @endif>
                                <label for="myname">User Spacific Workout Plans <span class="text-danger">*</span></label>
                                <select id="allUser" name="user_workout_plan" readonly class="form-control selectpicker" data-live-search="true" >
                                    <option value="" selected disabled>Select User Spacific Workout</option>
                                    @foreach($userWorkoutPlans as $list)
                                    <option value="{{$list->id}}" @if($workoutplan->id==$list->id) selected @endif>{{$list->title}} - @if($list->is_paid==1) Paid @else Free @endif - {{$list->user->email}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group paidUserSelect" @if(!empty($workoutplan->user)) style="display:none" @endif>
                                <label for="myname">All Workout Plans <span class="text-danger">*</span></label>
                                <select id="paidUser" name="workout_plan" readonly class="form-control selectpicker" data-live-search="true" >
                                    <option value="" selected disabled>Select Workout</option>
                                    @foreach($workoutPlans as $list)
                                    <option value="{{$list->id}}" @if($workoutplan->id==$list->id) selected @endif>{{$list->title}} -  @if($list->is_paid==1) Paid @else Free @endif</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    <div id="exampleModalLiveq" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLivecloneLabelq" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLivecloneLabelq">Edit Workout Plan Days</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body ">
                    <form action="{{route('update_workout_plan_days')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                        <div class="row">
                            @csrf
                            <div class="col-md-12">
                            
                                <div class="form-group col-12">
                                    <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control editTitle"  placeholder="Title" name="title" required>
                                    <input type="hidden" class="form-control editUUID"  name="uuid" >
                                </div>
                                <div class="form-group col-12">
                                    <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" name="image" >
                                    <br>
                                    <img src="{{env('APP_URL_STR').'workout/'}}" class="editImage" height="70" width="70">
                                </div>
                                <div class="form-group">
                                    <label for="myname">Is User Spacific <span class="text-danger">*</span></label>
                                    <div class="form-group">
                                        <span style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selectededit" onclick="return false;" value="yes" id="editis_user_selected1yes" required >
                                            <label for="is_user_selected1yes">Yes</label>
                                        </span>
                                        <span  style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selectededit" onclick="return false;" value="no" id="editis_user_selected1no" checked required >
                                            <label for="is_user_selected1no">No</label>
                                        </span>
                                    </div>
                                </div>
                            
                                <div class="form-group allUserSelectEdit" style="display:none">
                                    <label for="myname">User Spacific Workout Plans <span class="text-danger">*</span></label>
                                    <select id="allUserEdit" name="alluser" readonly class="form-control selectpicker" data-live-search="true" >
                                        <option value="" selected disabled>Select User Spacific Workout</option>
                                        @foreach($userWorkoutPlans as $list)
                                        <option value="{{$list->id}}" @if($workoutplan->id==$list->id) selected @endif>{{$list->title}} - @if($list->is_paid==1) Paid @else Free @endif - {{$list->user->email}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group paidUserSelectEdit" >
                                    <label for="myname">All Workout Plans <span class="text-danger">*</span></label>
                                    <select id="paidUser" name="workout_plan" readonly class="form-control selectpicker" data-live-search="true" >
                                        <option value="" selected disabled>Select Workout</option>
                                        @foreach($workoutPlans as $list)
                                        <option value="{{$list->id}}" @if($workoutplan->id==$list->id) selected @endif>{{$list->title}} -  @if($list->is_paid==1) Paid @else Free @endif</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @forelse($workoutplan->workout_days as $idx=> $plan_days)
        <div id="exampleModalLiveEdit{{$idx}}" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveEdit{{$idx}}Label" aria-hidden="true">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLiveEdit{{$idx}}Label">Add a new exercise</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    </div>
                    <div class="modal-body">
                    <form action="{{route('save_workout_days')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                        <div class="row">
                            @csrf
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="workoutplanday">Workout Plan </label><br>
                                        <b>{{$workoutplan->title}}</b>
                                    <input class="form-control " type="hidden"  id="workoutplan" value="{{$plan_days->uuid}}" name="workoutplan" >
                                </div>
                                <div class="form-group">
                                    <label for="workoutplanday">Workout Plan Day </label><br>
                                        <b>{{$plan_days->title}}</b>
                                    <input class="form-control " type="hidden"  id="workoutplanday" value="{{$plan_days->uuid}}" name="workoutplanday" >
                                </div>
                                <div class="afterWorkoutChoose" >
                                    <div class="form-group">
                                        <label for="exercise_type">Exercise Type <span class="text-danger">*</span></label>
                                        <select class="form-control" id="exercise_type" name="exercise_type" required>
                                            <option value="" selected disabled>Select Exercise Type</option>
                                            <option value="strength">STRENGTH </option>
                                            <option value="endurance">ENDURANCE  </option>
                                            <option value="bodyweight">BODYWEIGHT </option>
                                        </select>
                                    </div>
                                    <div class="afterWorkoutTypeChoose" style="display:none">
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" placeholder="Title" name="title" required>
                                        </div>
                                        <div class="form-group strengthField">
                                            <label for="exercise_machine">Strength Machines <span class="text-danger">*</span></label>
                                            <select class="form-control" id="exercise_machine" name="exercise_machine"  required>
                                                <option value="" selected disabled>Select Exercise Type</option>
                                                @foreach($exercise_machines as $list_m)<option value="{{$list_m->uuid}}" >{{$list_m->name}}</option>@endforeach
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                            <input type="file" class="form-control" name="image" required>
                                        </div>
                                        <div class="form-group">
                                            <label for="videotype">Video Type <span class="text-danger">*</span></label>
                                            <select class="form-control" id="videotype" name="videotype" required>
                                                <option value="" selected disabled>Select Video Type</option>
                                                <option value="youtube" selected>Youtube</option>
                                            </select>
                                        </div>
                                        <div class="form-group">
                                            <label for="videourl">Video URL <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" name="videourl" id="videourl" required placeholder="Enter url">
                                        </div>
                                        <div class="form-group strengthField enduranceField bodyweightField">
                                            <label for="exampleInputEmail1">No of Reps <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" placeholder="No of Reps" name="no_of_reps" >
                                        </div>
                                        <div class="form-group strengthField enduranceField bodyweightField">
                                            <label for="exampleInputEmail1">No of Sets <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" placeholder="No of Sets" name="no_of_sets" >
                                        </div>
                                        <div class="form-group strengthField ">
                                            <label for="exampleInputEmail1">Default Weight <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" placeholder="Default Weight" name="default_weight" >
                                        </div>
                                        <div class="form-group strengthField enduranceField">
                                            <label for="exampleInputEmail1">Take Time <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" placeholder="Take Time" name="take_time" >
                                        </div>
                                        <div class="form-group">
                                            <label for="myname">Is Rest After <span class="text-danger">*</span></label>
                                            <div class="form-group">
                                                <span style="padding: 0px 25px">
                                                    <input type="radio" name="ispaid" id="ispaidyes" value="yes" required >
                                                    <label for="ispaidyes">Yes</label>
                                                </span>
                                                <span  style="padding: 0px 25px">
                                                    <input type="radio" name="ispaid" id="ispaidno" value="no" checked required >
                                                    <label for="ispaidno">No</label>
                                                </span>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>
                        
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                    </div>
                </div>
            </div>
        </div>
    @endforeach

    {{-- importWorkout --}}
    <div id="importWorkout" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="importWorkoutLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="importWorkoutLabel">Import Workout Plan Day</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                    <form action="{{route('import_exercise_details')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                        <div class="row">
                            @csrf
                            <div class="col-md-12">
                                <div class="form-group " >
                                    <label for="importPlan">Workout Plans </label>
                                    <select id="importPlan" name="import_plan" class="form-control selectpicker" data-live-search="true" >
                                        <option value="" selected disabled>Select Workout</option>
                                        @foreach($allWorkoutPlans as $list)
                                            <option value="{{$list->uuid}}" >{{$list->title}} -  @if($list->is_paid==1) Paid @else Free @endif</option>
                                        @endforeach
                                    </select>
                                </div>
                                <input class="form-control " type="hidden"  id="workoutplan" value="{{$workoutplan->uuid}}" name="workoutplan" >
                                <div class="loader" style="display:none;"></div> 
                                <div class="form-group nextDays" >
                                     
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer ">
                            <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit"  style="display:none;" class="btn bg-gradient-info pr afterImport">Import</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $(document).on('change',"#workoutplanday",(res)=>{
            if(res.target.value==""){
                $(document).find('.afterWorkoutChoose').hide();
            } else {
                $(document).find('.afterWorkoutChoose').show();
            }
        });
        $(document).on('change',"#exercise_type",(res)=>{
            if(res.target.value==""){
                $(document).find('.afterWorkoutTypeChoose').hide();
            } else {
                if(res.target.value=="strength"){
                    $(document).find('.strengthField,.enduranceField,.bodyweightField').hide();
                    $(document).find('.strengthField').show();
                }
                if(res.target.value=="endurance"){
                    $(document).find('.strengthField,.enduranceField,.bodyweightField').hide();
                    $(document).find('.enduranceField').show();
                }
                if(res.target.value=="bodyweight"){
                    $(document).find('.strengthField,.enduranceField,.bodyweightField').hide();
                    $(document).find('.bodyweightField').show();
                }
                $(document).find('.afterWorkoutTypeChoose').show();
            }
        });
        $(document).on('change','input[name=ispaid]',(res)=>{
            var type = $('input[name=ispaid]:checked').val();
            var is_user_selected = $('input[name=is_user_selected]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });
        $(document).on('change','input[name=is_user_selected]',(res)=>{
            var type = $('input[name=ispaid]:checked').val();
            var is_user_selected = $('input[name=is_user_selected]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });

        $(document).on('click','.editModel',(e)=>{
            var data = JSON.parse(atob($(e.target).data('array')));
            console.log(data)
            $('.editTitle').val(data.title);
            $('.editUUID').val(data.uuid);
         
            $('.editImage').attr("src","{{env('APP_URL_STR').'workout/'}}"+data.image);
 
            if(data.user_id!=null){
                $('#editis_user_selected1yes').prop("checked","true");
                $('#editis_user_selected1no').removeAttr("checked");
                $('select[name="alluser"]').find('option[value="'+data.plans_uuid.id+'"]').attr("selected",true);
         
                var is_user_selected = $('input[name=is_user_selectededit]:checked').val();
                if(is_user_selected=='no'){
                    $('.allUserSelectEdit').hide();
                    $('.paidUserSelectEdit').show();
                  
                } else {
                    $('.allUserSelectEdit').show();
                    $('.paidUserSelectEdit').hide();
                }
            } else {
                $('select[name="workout_plan"]').find('option[value="'+data.plans_uuid.id+'"]').attr("selected",true);
                // $('select[name="alluser"]').find('option[value=""]').attr("selected",true);
                $('.allUserSelectEdit').hide();
                    $('.paidUserSelectEdit').show();
                $('#editis_user_selected1yes').removeAttr("checked");
                $('#editis_user_selected1no').prop("checked","true");
                
            }
         
        });

        //afterImport
        $(document).on('change','#importPlan',(e)=>{
            var data = e.target.value;
            $('.loader').show();
            $('.afterImport').hide();
            $.post('{{route("get_exercise_details")}}',{'id':data,'_token':'{{csrf_token()}}'},function(res){
                $('.loader').hide();
                $('.afterImport').show();
                $('.nextDays').html(res);
            });
            console.log(data);
        });

        
        
    </script>
    <script>
        $( '#exercise_machine' ).select2({
            width: "100%",
            placeholder: $( this ).data( 'placeholder' ),
        } );
    </script>
</body>

</html>