<!DOCTYPE html>
<html lang="en">

<head>
    <title>Workout Days</title>
    @include('includes.header')
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('workout_days','update'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Workout Days</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Workout Days</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Workout Days</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Is User Spacific</th>
                                            <th>Workout Plan Day</th>
                                            <th>exersice_type</th>
                                            <th>Title</th>
                                            <th>Image</th>
                                            <th>take_time</th>
                                            <th>is_rest_after</th>
                                            <th>rest_text</th>
                                            <th>rest_duration</th>
                                            <th>no_of_reps</th>
                                            <th>default_weight</th>
                                            <th>no_of_sets</th>
                                            <th>any_warning</th>
                                            <th>safety_text</th>
                                            <th>video_type</th>
                                            <th>video_url</th>
                                            <th>Status</th>
                                            @if(permission('workout_days','update') || permission('workout_days','delete'))
                                            <th>Action</th>
                                            @endif
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($plans as $index => $list)
                                        <tr>
                                            <td>{{$list->id}}</td>
                                            <td>@if(!empty($list->user->name)){{$list->user->name}}@else <span class="badge bg-gradient-warning">Available All Users</span>@endif</td>
                                            <td>{{$list->workout_plan_days->title ?? "N/A"}}</td>
                                            <!-- <td>@if(!empty($list->user->name)){{$list->user->name}}@else <span class="badge bg-gradient-warning">Available All Users</span>@endif</td> -->
                                            <td>{{$list->exersice_type}}</td>
                                            <td>{{$list->title}} {{$list->plan->title ?? ''}}</td>
                                            <td><img src="{{env('APP_URL_STR').'workout/'}}{{$list->image}}" height="70" width="70"></td>
                                            <td>{{$list->take_time}}</td>
                                            <td>{{$list->is_rest_after == 0 ? 'yes':"no"}}</td>
                                            <td>{{$list->rest_text}}</td>
                                            <td>{{$list->rest_duration}}</td>
                                            <td>{{$list->no_of_reps}}</td>
                                            <td>{{$list->default_weight}}</td>
                                            <td>{{$list->no_of_sets}}</td>
                                            <td>{{$list->any_warning}}</td>
                                            <td>{{$list->safety_text}}</td>
                                            <td>{{$list->video_type}}</td>
                                            <td>
                                                @if(!empty($list->video_url))
                                                    <span class="badge bg-gradient-success">Added</span>
                                                @else
                                                    <span class="badge bg-gradient-danger">Not Added</span>
                                                @endif
                                                
                                            </td>
                                            
                                            <td>
                                                @if($list->status==0)<span class="badge bg-gradient-danger">Inactive</span>@endif
                                                @if($list->status==1)<span class="badge bg-gradient-success">Active</span>@endif
                                                @if($list->status==2)<span class="badge bg-gradient-warning">Draft</span>@endif
                                            </td>
                                            @if(permission('workout_days','update') || permission('workout_days','delete'))
                                            <td>
                                                @if(permission('workout_days','update'))
                                                    <form style="float:left" action="{{route('status-workout_days',['id'=>$list->id])}}" method="post" onsubmit="return confirm('Change Status')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-dark mr-1"><i class="feather icon-refresh-cw"></i></button>
                                                    </form>
                                                    <!-- <button class="btn btn-sm bg-gradient-info pr"  data-toggle="modal" data-target="a#exampleModalLive{{$index}}q"><i class="feather icon-edit"></i></button> -->
                                                @endif
                                                @if(permission('workout_days','delete'))
                                                    <form style="float:left" action="{{route('delete-workout_days',['id'=>$list->id])}}" method="post" onsubmit="return confirm('Are you sure? Delete')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-danger mr-1"><i class="feather icon-trash-2"></i></button>
                                                    </form>
                                                @endif
                                            </td>
                                            @endif
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="18" class="text-center"> Empty</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                                {{ $plans->links('pagination.simple') }}
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Workout Days</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save_workout_days')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="workoutplanday">Workout Plan Day <span class="text-danger">*</span></label>
                                <select class="form-control" id="workoutplanday" name="workoutplanday" required>
                                    <option value="" selected disabled>Select Workout Plan Day</option>
                                    @foreach($workoutPlans as $list)
                                    <option value="{{$list->uuid}}">{{$list->title}} - {{$list->plan->title??""}} - {{$list->user->email??''}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="afterWorkoutChoose" style="display:none">
                                <div class="form-group">
                                    <label for="exercise_type">Exercise Type <span class="text-danger">*</span></label>
                                    <select class="form-control" id="exercise_type" name="exercise_type" required>
                                        <option value="" selected disabled>Select Exercise Type</option>
                                        <option value="strength">STRENGTH </option>
                                        <option value="endurance">ENDURANCE  </option>
                                        <option value="bodyweight">BODYWEIGHT </option>
                                    </select>
                                </div>
                                <div class="afterWorkoutTypeChoose" style="display:none">
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="Title" name="title" required>
                                    </div>
                                    <div class="form-group strengthField">
                                        <label for="exercise_machine">Strength Machines <span class="text-danger">*</span></label>
                                        <select class="form-control" id="exercise_machine" name="exercise_machine" required>
                                            <option value="" selected disabled>Select Exercise Type</option>
                                            @foreach($exercise_machines as $list_m)<option value="{{$list_m->uuid}}" >{{$list_m->name}}</option>@endforeach
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                        <input type="file" class="form-control" name="image" required>
                                    </div>
                                    <div class="form-group">
                                        <label for="videotype">Video Type <span class="text-danger">*</span></label>
                                        <select class="form-control" id="videotype" name="videotype" required>
                                            <option value="" selected disabled>Select Video Type</option>
                                            <option value="youtube" selected>Youtube</option>
                                        </select>
                                    </div>
                                    <div class="form-group">
                                        <label for="videourl">Video URL <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="videourl" id="videourl" required placeholder="Enter url">
                                    </div>
                                    <div class="form-group strengthField enduranceField bodyweightField">
                                        <label for="exampleInputEmail1">No of Reps <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="No of Reps" name="no_of_reps" >
                                    </div>
                                    <div class="form-group strengthField enduranceField bodyweightField">
                                        <label for="exampleInputEmail1">No of Sets <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="No of Sets" name="no_of_sets" >
                                    </div>
                                    <div class="form-group strengthField ">
                                        <label for="exampleInputEmail1">Default Weight <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="Default Weight" name="default_weight" >
                                    </div>
                                    <div class="form-group strengthField enduranceField">
                                        <label for="exampleInputEmail1">Take Time <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" placeholder="Take Time" name="take_time" >
                                    </div>
                                    <div class="form-group">
                                        <label for="myname">Is Rest After <span class="text-danger">*</span></label>
                                        <div class="form-group">
                                            <span style="padding: 0px 25px">
                                                <input type="radio" name="ispaid" id="ispaidyes" value="yes" required >
                                                <label for="ispaidyes">Yes</label>
                                            </span>
                                            <span  style="padding: 0px 25px">
                                                <input type="radio" name="ispaid" id="ispaidno" value="no" checked required >
                                                <label for="ispaidno">No</label>
                                            </span>
                                        </div>
                                    </div>
                                    
                                </div>
                            </div>
                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    @foreach($plans as $index => $list)
    <div id="exampleModalLive{{$index}}q" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLive{{$index}}qLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive{{$index}}qLabel">Edit Exercise Category</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('update-exercise-categories',['id'=>$list->id])}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label for="myname">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="myname" value="{{$list->name}}" id="myname" required placeholder="Enter name">
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="image" @if(empty($list->image)) required @endif>
                                <img src="{{env('APP_URL_STR').'exercise_cats/'}}{{$list->image}}" height="70" width="70">
                            </div>
                        </div>
                    
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>
    @endforeach
    <!-- Apex Chart -->
    <script src="{{asset('assets/js/plugins/apexcharts.min.js')}}"></script>
    <!-- custom-chart js -->
    <script src="{{asset('assets/js/pages/dashboard-main.js')}}"></script>

    <script>
        $(document).on('change',"#workoutplanday",(res)=>{
            if(res.target.value==""){
                $(document).find('.afterWorkoutChoose').hide();
            } else {
                $(document).find('.afterWorkoutChoose').show();
            }
        });
        $(document).on('change',"#exercise_type",(res)=>{
            if(res.target.value==""){
                $(document).find('.afterWorkoutTypeChoose').hide();
            } else {
                if(res.target.value=="strength"){
                    $(document).find('.strengthField,.enduranceField,.bodyweightField').hide();
                    $(document).find('.strengthField').show();
                }
                if(res.target.value=="endurance"){
                    $(document).find('.strengthField,.enduranceField,.bodyweightField').hide();
                    $(document).find('.enduranceField').show();
                }
                if(res.target.value=="bodyweight"){
                    $(document).find('.strengthField,.enduranceField,.bodyweightField').hide();
                    $(document).find('.bodyweightField').show();
                }
                $(document).find('.afterWorkoutTypeChoose').show();
            }
        });
        $(document).on('change','input[name=ispaid]',(res)=>{
            var type = $('input[name=ispaid]:checked').val();
            var is_user_selected = $('input[name=is_user_selected]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });
        $(document).on('change','input[name=is_user_selected]',(res)=>{
            var type = $('input[name=ispaid]:checked').val();
            var is_user_selected = $('input[name=is_user_selected]:checked').val();
            if(is_user_selected=='yes'){
                if(type=="yes"){
                    $('.allUserSelect').hide();
                    $('.paidUserSelect').show();
                }
                if(type=="no"){
                    $('.allUserSelect').show();
                    $('.paidUserSelect').hide();
                }
            } else {
                $('.allUserSelect').hide();
                $('.paidUserSelect').hide();
            }
           
        });

        
    </script>
</body>

</html>