<!DOCTYPE html>
<html lang="en">

<head>
    <title>Workout Plan Days</title>
    @include('includes.header')
    <script src="{{asset('assets/js/bs/bootstrap.min.css')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.css')}}"></script> 
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            @if(permission('workout_plan_days','update'))<button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New Workout Plan Day</button>@endif
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Workout Plan Days</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Workout Plan Days</h5>
                            <div class="row">
                                <div class="col-xl-5"></div>
                                <div class="col-xl-3"> </div>
                                <div class="col-xl-3">
                                    <div >User</div>
                                    <select class="form-control getUser" >
                                        <option value="all">All users</option>
                                        @foreach($users as $user)
                                        <option value="{{$user->id}}">{{$user->name}} - {{$user->email}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-xl-1">
                                    <button class="mt-4 p-2 btn bg-gradient-dark" id="reloadData"><i class="fa fa-refresh"></i></button>
                                </div>
                            </div>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                            <table id="getUserData" class="table table-striped" style="width:100%">
                            </table>
                              
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')
    <script src="{{asset('assets/js/bs/dataTables.js')}}"></script>
    <script src="{{asset('assets/js/bs/dataTables.bootstrap5.js')}}"></script>
    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New Workout Plan Days</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body">
                <form action="{{route('save_workout_plan_days')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                    <div class="row">
                        @csrf
                        <div class="col-md-12">
                           
                            <div class="form-group">
                                <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" placeholder="Title" name="title" required>
                            </div>
                            <div class="form-group">
                                <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                <input type="file" class="form-control" name="image" >
                            </div>
                            <div class="form-group">
                                <label for="myname">Is User Spacific <span class="text-danger">*</span></label>
                                <div class="form-group"     >
                                    <span style="padding: 0px 25px">
                                        <input type="radio" name="is_user_selected" value="yes" id="is_user_selectedyes" required >
                                        <label for="is_user_selectedyes">Yes</label>
                                    </span>
                                    <span  style="padding: 0px 25px">
                                        <input type="radio" name="is_user_selected" value="no" id="is_user_selectedno" checked required >
                                        <label for="is_user_selectedno">No</label>
                                    </span>
                                </div>
                            </div>
                           
                            <div class="form-group allUserSelect" style="display:none">
                                <label for="myname">User Spacific Workout Plans <span class="text-danger">*</span></label>
                                <select id="allUser" name="user_workout_plan" class="form-control selectpicker" data-live-search="true" >
                                    <option value="" selected disabled>Select User Spacific Workout</option>
                                    @foreach($userWorkoutPlans as $list)
                                    <option value="{{$list->id}}">{{$list->title}} - @if($list->is_paid==1) Paid @else Free @endif - {{$list->user->email}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group paidUserSelect" >
                                <label for="myname">All Workout Plans <span class="text-danger">*</span></label>
                                <select id="paidUser" name="workout_plan" class="form-control selectpicker" data-live-search="true" >
                                    <option value="" selected disabled>Select Workout</option>
                                    @foreach($workoutPlans as $list)
                                    <option value="{{$list->id}}">{{$list->title}} -  @if($list->is_paid==1) Paid @else Free @endif</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                    </div>
                </form>
                </div>
            </div>
        </div>
    </div>

    <div id="exampleModalLiveq" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLivecloneLabelq" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLivecloneLabelq">Edit Workout Plan Days</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
                <div class="modal-body ">
                    <form action="{{route('update_workout_plan_days')}}" id="storeUser" method="post" enctype='multipart/form-data'>
                        <div class="row">
                            @csrf
                            <div class="col-md-12">
                            
                                <div class="form-group col-12">
                                    <label for="exampleInputEmail1">Title <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control editTitle"  placeholder="Title" name="title" required>
                                    <input type="hidden" class="form-control editUUID"  name="uuid" >
                                </div>
                                <div class="form-group col-12">
                                    <label for="exampleInputEmail1">Image <span class="text-danger">*</span></label>
                                    <input type="file" class="form-control" name="image" >
                                    <br>
                                    <img src="{{env('APP_URL_STR').'workout/'}}" class="editImage" height="70" width="70">
                                </div>
                                <div class="form-group">
                                    <label for="myname">Is User Spacific <span class="text-danger">*</span></label>
                                    <div class="form-group">
                                        <span style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selectededit" value="yes" id="editis_user_selected1yes" required >
                                            <label for="is_user_selected1yes">Yes</label>
                                        </span>
                                        <span  style="padding: 0px 25px">
                                            <input type="radio" name="is_user_selectededit" value="no" id="editis_user_selected1no" checked required >
                                            <label for="is_user_selected1no">No</label>
                                        </span>
                                    </div>
                                </div>
                            
                                <div class="form-group allUserSelectEdit" style="display:none">
                                    <label for="myname">User Spacific Workout Plans <span class="text-danger">*</span></label>
                                    <select id="allUserEdit" name="alluser" class="form-control selectpicker" data-live-search="true" >
                                        <option value="" selected disabled>Select User Spacific Workout</option>
                                        @foreach($userWorkoutPlans as $list)
                                        <option value="{{$list->id}}">{{$list->title}} - @if($list->is_paid==1) Paid @else Free @endif - {{$list->user->email}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="form-group paidUserSelectEdit" >
                                    <label for="myname">All Workout Plans <span class="text-danger">*</span></label>
                                    <select id="paidUser" name="workout_plan" class="form-control selectpicker" data-live-search="true" >
                                        <option value="" selected disabled>Select Workout</option>
                                        @foreach($workoutPlans as $list)
                                        <option value="{{$list->id}}">{{$list->title}} -  @if($list->is_paid==1) Paid @else Free @endif</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
   

    <script>
   
        $(document).on('change','input[name=is_user_selected]',(res)=>{
            var is_user_selected = $('input[name=is_user_selected]:checked').val();
            if(is_user_selected=='no'){
                $('.allUserSelect').hide();
                $('.paidUserSelect').show();
            } else {
                $('.allUserSelect').show();
                $('.paidUserSelect').hide();
            }
           
        });
        $(document).on('change','input[name=is_user_selectededit]',(res)=>{
            var is_user_selected = $('input[name=is_user_selectededit]:checked').val();
            if(is_user_selected=='no'){
                $('.allUserSelectEdit').hide();
                $('.paidUserSelectEdit').show();
            } else {
                $('.allUserSelectEdit').show();
                $('.paidUserSelectEdit').hide();
            }
           
        });

        $(document).on('click','#reloadData',(res)=>{
            getData();
        });
        function getData(){
            $(document).ready(()=>{
                $('#getUserData').DataTable( {
                    "ajax": {
                        "url": "{{route('get-wrokoutplansday-datatable')}}",
                        "data": function ( d ) {
                                d.selectedUser=$('.getUser').val();
                            },
                            "dataSrc": function ( json ) {
                                return json.data;
                            }
                    },
                    fixedHeader: true,
                    responsive: true,
                    processing: true,
                    serverSide: true,
                    columns: [
                        { data: 'id',title:"#" },
                        { data: 'user',title:"User","render":function(data,type,row){
                            if(data=="" || data==null){
                                return `Available All Users`;
                            } else {
                                return data.name+"<br>"+data.email;
                            }
                            
                            }},
                        { data: 'title',title:"Title" },
                        { data: 'id',title:"Workout Info",
                            "render":function(data,type,row){
                                if(row['plans_uuid']==null){
                                    return `<span class="badge bg-gradient-danger">Workout Not Exist</span>`;
                                } else{
                                    return row['plans_uuid']['title']+` <span class="p-1 bg-gradient-secondary "><i class="feather icon-external-link"></i></span>`;
                                }
                            }
                        },
                        { data: 'image',title:"Image" ,
                            "render":function(data,type,row){
                            return `<img src="{{env('APP_URL_STR').'workout/'}}`+data+`" height="70" width="70">`;
                            }
                        },
                       
                       
                        { data: 'status',title:"Status",
                            "render":function(data,type,row){
                                if(data==1){
                                    return `<span class="badge bg-gradient-success">Active</span>`;
                                } else if(data==0){
                                    return `<span class="badge bg-gradient-danger">Inactive</span>`;
                                } else if(data==2){
                                    return `<span class="badge bg-gradient-warning">Draft</span>`;
                                }
                            }
                        },
                        { data: 'id',title:"Action",orderable:false,
                            "render":function(data,type,row){
                                var statusUrl = "{{ route('status-workout_plan_days', ['id' => ':id']) }}";
                                    statusUrl = statusUrl.replace(':id', data);
                                var deletePlanURL = "{{ route('delete-workout_plan_days', ['id' => ':id']) }}";
                                    deletePlanURL = deletePlanURL.replace(':id', data);

                                var userListURL = "{{ route('view_workout_plan_days', ['id' => ':id']) }}";
                                    userListURL = userListURL.replace(':id', btoa(data));
                                    return ` @if(permission('workout_plan_days','update') || permission('workout_plan_days','delete'))
                                                @if(permission('workout_plan_days','update'))
                                                    @if(permission('workout_days','read')){
                                                    <a href="`+userListURL+`">
                                                        <button class="btn btn-sm bg-gradient-dark mr-1 editModel" style="float:left" ><i class="feather icon-list"></i></button>
                                                    </a>
                                                    @endif
                                                    <form style="float:left" action="`+statusUrl+`" method="post" onsubmit="return confirm('Change Status')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-warning mr-1"><i class="feather icon-refresh-cw"></i></button>
                                                    </form>
                                                    <button class="btn btn-sm bg-gradient-info mr-1 editModel" style="float:left"  data-toggle="modal" data-target="#exampleModalLiveq" data-array="`+btoa(JSON.stringify(row))+`"><i class="feather icon-edit" data-array="`+btoa(JSON.stringify(row))+`"></i></button> 
                                                @endif
                                                @if(permission('workout_plan_days','delete'))
                                                    <form style="float:left" action="`+deletePlanURL+`" method="post" onsubmit="return confirm('Are you sure? Delete')">
                                                        @csrf
                                                        @method('PUT')
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </form>
                                                @endif
                                            
                                            @endif
                                            
                                            `;
                            
                            }
                        },
                    ],
                    language: {
                        searchPlaceholder: "By Title"
                    },
                    retrieve: true,
                }).ajax.reload();
            });
            
        }
        this.getData();

        $(document).on('click','.editModel',(e)=>{
            var data = JSON.parse(atob($(e.target).data('array')));
            console.log(data)
            $('.editTitle').val(data.title);
            $('.editUUID').val(data.uuid);
         
            $('.editImage').attr("src","{{env('APP_URL_STR').'workout/'}}"+data.image);
 
            if(data.user_id!=null){
                $('#editis_user_selected1yes').prop("checked","true");
                $('#editis_user_selected1no').removeAttr("checked");
                $('select[name="alluser"]').find('option[value="'+data.plans_uuid.id+'"]').attr("selected",true);
         
                var is_user_selected = $('input[name=is_user_selectededit]:checked').val();
                if(is_user_selected=='no'){
                    $('.allUserSelectEdit').hide();
                    $('.paidUserSelectEdit').show();
                  
                } else {
                    $('.allUserSelectEdit').show();
                    $('.paidUserSelectEdit').hide();
                }
            } else {
                $('select[name="workout_plan"]').find('option[value="'+data.plans_uuid.id+'"]').attr("selected",true);
                // $('select[name="alluser"]').find('option[value=""]').attr("selected",true);
                $('.allUserSelectEdit').hide();
                    $('.paidUserSelectEdit').show();
                $('#editis_user_selected1yes').removeAttr("checked");
                $('#editis_user_selected1no').prop("checked","true");
                
            }
         
        });
    </script>
    
</body>

</html>