<!DOCTYPE html>
<html lang="en">

<head>
    <title> Language - {{$lang->name}} </title>
    <style>
        .table-responsive {
            height: 600px;
        }
        .tox-tinymce{
            height:100% !important;
        }
        .colr:nth-child(odd){
            background-color:#e2e2e2;
        }
        .colr:nth-child(even){
            background-color:#ddf3dd;
        }
    </style>
    @include('includes.header')
    <script src="https://cdn.tiny.cloud/1/vzsbabl41dquoqb8uiq1co621duklluitrrj6akhlplahhqx/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
    <script>
    tinymce.init({
        selector: 'textarea',
        menubar: false,
        plugins: [
        'code ',
        ],
        toolbar: 'code ',
        advcode_inline: true,
        //content_css: '//www.tinymce.com/css/codepen.min.css',
        content_style: 'p {margin: 0px; border: 0px solid red; padding: 0px}'
    });
    </script>
</head>
<body>
@include('includes.flash-sms')
@include('includes.navbar')
@include('includes.topbar')
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            <!-- @if(permission('language','update'))<button class="m-b-10 btn bg-gradient-success" id="storeUser">Save</button>@endif -->
                            </div>
                            <div class="float-left">
                                <button class="m-b-10 btn bg-gradient-dark" onclick="goBack()"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</button>
                            </div>
                            
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="{{route('dashboard')}}"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Language - {{$lang->name}}</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Language {{$lang->name}}</h5>
                       
                        </div>
                        <div class="card-body table-border-style">
                            @foreach($file_convert as $int=>$list)
                                <div class="colr float-left w-100 p-4">
                                    @if(is_array($list))
                                        <h2 style="text-transform: capitalize;">{{str_replace('_',' ',$int)}}</h2>
                                        @foreach($list as $sint=> $slist)
                                            
                                                @if(is_array($slist))
                                                <br>
                                                <h5 style="text-transform: capitalize;">{{str_replace('_',' ',$sint)}}</h5>
                                                
                                                <div class=" w-100 float-left ">
                                                    @foreach($slist as $dint=>$dlist)
                                                    
                                                        <div class="float-left p-2">
                                                            <label style="text-transform: capitalize;">{{str_replace('_',' ',$dint)}}</label>
                                                            <input type="text" value="{{$dlist}}"  class="form-control" style="width: 220px; " placeholder="{{$dint}}">
                                                        </div>
                                                        
                                                    @endforeach
                                                </div>
                                                <br><br>
                                                @else
                                                
                                                    <div class="float-left p-2">
                                                        <label style="text-transform: capitalize;">{{str_replace('_',' ',$sint)}}</label>
                                                        <input type="text" value="{{$slist}}" class="form-control" style="width: 220px; " placeholder="{{$sint}}">
                                                    </div>
                                                @endif
                                            
                                        @endforeach
                                        <br><br>
                                    @else
                                        <div class="float-left p-2">
                                            <label style="text-transform: capitalize;">{{str_replace('_',' ',$int)}}</label>
                                            <input type="text" value="{{$list}}" class="form-control" style="width: 220px; " placeholder="{{$int}}">
                                        </div>
                                    @endif
                                </div>
                            @endforeach
                            <div class="table-responsive d-none">
                                <textarea name="html" id="getHTML" >{!! $file !!}</textarea>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    @include('includes.footer')

    <script>
       
       $(document).on('click','#storeUser',()=>{
           var cont = tinymce.get("getHTML").getContent();
            //    $('#getHTML').html(cont);
           console.log(cont)
          
            $.ajax({url:'{{route("update-diet-plan",["id"=>$lang->id])}}',type: 'PUT',data:{html:cont,_token:"{{csrf_token()}}"},
                    success: function(result) {
                        $("#gen-loading").hide();
                        Swal.fire({
                            position: "top-end",
                            icon: "success",
                            title: result.message,
                            showConfirmButton: false,
                            timer: 1500
                        });
                    },
                    error: function(request,msg,error) {
                        $("#gen-loading").hide();
                        console.log(request)
                        Swal.fire({
                            position: "top-end",
                            icon: "error",
                            title: "Something went wrong!",
                            showConfirmButton: false,
                            timer: 1500
                        })
                    }
                }
            );
       });

   

        function goBack() {
            history.back()
        }
   </script>
</body>

</html>