<script type="module" src="https://cdn.jsdelivr.net/npm/@ionic/core/dist/ionic/ionic.esm.js"></script>
<script nomodule src="https://cdn.jsdelivr.net/npm/@ionic/core/dist/ionic/ionic.js"></script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@ionic/core/css/ionic.bundle.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.3.1/jquery.min.js"></script>
<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

<style>
    .set_headng_w{
    font-size: 20px;
    font-weight: 700;
    color: #000;
    padding: 10px 0 0 0;
    font-style: normal;
    }
    .set_top_icon{
        font-size: 17px;
        font-weight: 800;
        color: #000;
        padding-top: 13px;
    }
    .set_border_trainer{
    border-radius: 13px;
    border: 1px solid #D4D4D4;
    padding: 0px 0 0 3px;
    }

    
    /* Hide the actual file input */
    #file-input {
        position: absolute;
        left: -9999px;
    }
    
    /* Style the icon */
    .file-input-label i {
        margin-left: 5px;
    }
    
    #preview-container {
        margin-top: 20px;
    }
    
    /* Style for the preview image */
    #preview-container img {
        max-width: 300px;
        max-height: 300px;
        margin-top: 10px;
    }
    ion-card {
        width: 100%;
        border-radius: 6px;
        background: #FFF;
        box-shadow: 0px 4px 12px 0px rgba(0, 0, 0, 0.05);
    }
    ion-card-title {
        color: #303841;
    font-family: Montserrat;
    font-size: 13.38px;
    font-style: normal;
    font-weight: 600;
    line-height: 10px;
    }
    p{
        color: #303841;
    font-family: Montserrat;
    font-size: 12.162px;
    font-style: italic;
    font-weight: 500;
    line-height: 19.6px; /* 161.152% */
    }
  ion-button.footer_btn {
    --background: #FE8B2E;
    --background-hover: #FE8B2E;
    --background-activated: #FE8B2E;
    --background-focused: #FE8B2E;
  
    --color: #fff;
    font-family: Montserrat;
  
    --border-radius:  14px;
    --border-color: #000;
    --border-style: solid;
    --border-width: 0px;
  
    --box-shadow: 0 2px 6px 0 rgb(0, 0, 0, 0.25);
  
    --ripple-color: #FE8B2E;
  
    --padding-top: 10px;
    --padding-bottom: 10px;
    width: 80%;
    text-transform: capitalize;
  }
</style>
<ion-content class="ion-padding ">
    <ion-grid>
      <ion-row class="set_padding_top_bar">
        <ion-col size="1" (click)="openPage('/form-builder-workouts')"> 
          <ion-icon class="set_top_icon" name="chevron-back-outline" ></ion-icon>
        </ion-col>
        <ion-col size="10" class="ion-text-center">
          <p class="set_headng_w">Upload your video<br><small>{{$workout->name??''}}</small></p>
        </ion-col>
        <ion-col size="1" class="ion-text-center">
          <!-- <ion-icon class="set_top_icon_add" title="fjhgfjkhk" name="add-circle-outline"></ion-icon> -->
        </ion-col>
      </ion-row>
      <ion-row >
        <ion-card class="ion-text-center">
          <label for="file-input" class="file-input-label">
            <svg xmlns="http://www.w3.org/2000/svg" width="74" height="74" viewBox="0 0 74 74" fill="none">
              <path d="M60.1257 9.25H10.7923C6.5351 9.25 3.08398 12.7011 3.08398 16.9583V53.9584C3.08398 58.2156 6.5351 61.6667 10.7923 61.6667H60.1257C64.3829 61.6667 67.834 58.2156 67.834 53.9584V16.9583C67.834 12.7011 64.3829 9.25 60.1257 9.25Z" fill="url(#paint0_linear_4651_7043)"/>
              <path opacity="0.5" d="M3.08398 52.418V53.9595C3.08397 54.9718 3.28334 55.9742 3.67072 56.9095C4.05809 57.8447 4.62589 58.6945 5.34169 59.4103C6.05749 60.1261 6.90726 60.6939 7.8425 61.0812C8.77774 61.4686 9.78012 61.668 10.7924 61.668H60.1257C61.138 61.668 62.1403 61.4686 63.0756 61.0812C64.0108 60.6938 64.8605 60.126 65.5763 59.4102C66.2921 58.6944 66.8599 57.8446 67.2473 56.9094C67.6346 55.9742 67.834 54.9718 67.834 53.9595V52.418H3.08398Z" fill="url(#paint1_linear_4651_7043)"/>
              <path d="M45.5563 29.8386L29.8313 20.7596C29.386 20.5025 28.8809 20.3672 28.3667 20.3672C27.8525 20.3672 27.3474 20.5026 26.9021 20.7596C26.4568 21.0167 26.087 21.3865 25.83 21.8318C25.5729 22.2771 25.4375 22.7822 25.4375 23.2964V41.4542C25.4356 41.9691 25.5697 42.4754 25.8263 42.9218C26.0829 43.3683 26.4529 43.739 26.8989 43.9965C27.3448 44.2539 27.8509 44.389 28.3658 44.388C28.8808 44.387 29.3863 44.25 29.8313 43.9908L45.5563 34.9119C46.0015 34.6548 46.3712 34.2851 46.6282 33.8398C46.8853 33.3946 47.0206 32.8895 47.0206 32.3754C47.0206 31.8613 46.8853 31.3562 46.6282 30.911C46.3712 30.4657 46.0015 30.096 45.5563 29.8389V29.8386Z" fill="url(#paint2_linear_4651_7043)"/>
              <path d="M57.8132 64.7514C65.0505 64.7514 70.9174 58.8844 70.9174 51.6472C70.9174 44.4099 65.0505 38.543 57.8132 38.543C50.5759 38.543 44.709 44.4099 44.709 51.6472C44.709 58.8844 50.5759 64.7514 57.8132 64.7514Z" fill="url(#paint3_radial_4651_7043)"/>
              <path d="M62.7562 49.0126L58.902 45.1584C58.6128 44.8694 58.2207 44.707 57.8119 44.707C57.403 44.707 57.0109 44.8694 56.7218 45.1584L52.8675 49.0126C52.7244 49.1558 52.6108 49.3257 52.5334 49.5128C52.4559 49.6998 52.416 49.9003 52.416 50.1028C52.416 50.3052 52.4559 50.5057 52.5334 50.6928C52.6109 50.8798 52.7244 51.0498 52.8676 51.1929C53.0108 51.3361 53.1807 51.4496 53.3678 51.5271C53.5548 51.6046 53.7553 51.6445 53.9578 51.6444C54.1602 51.6444 54.3607 51.6046 54.5478 51.5271C54.7348 51.4496 54.9048 51.336 55.0479 51.1928L56.2702 49.9705V57.0403C56.2742 57.4466 56.4383 57.8349 56.727 58.1208C57.0157 58.4067 57.4056 58.5671 57.8119 58.5671C58.2182 58.5671 58.6081 58.4067 58.8967 58.1208C59.1854 57.8349 59.3496 57.4466 59.3535 57.0403V49.9705L60.576 51.1928C60.7187 51.3378 60.8888 51.453 61.0763 51.5319C61.2638 51.6108 61.465 51.6518 61.6685 51.6525C61.8719 51.6533 62.0734 51.6138 62.2615 51.5363C62.4496 51.4588 62.6205 51.3448 62.7643 51.201C62.9082 51.0571 63.0221 50.8862 63.0996 50.6982C63.1771 50.5101 63.2166 50.3085 63.2159 50.1051C63.2151 49.9017 63.1741 49.7004 63.0952 49.5129C63.0163 49.3254 62.9011 49.1554 62.7562 49.0126Z" fill="url(#paint4_radial_4651_7043)"/>
              <defs>
                <linearGradient id="paint0_linear_4651_7043" x1="35.459" y1="10.2204" x2="35.459" y2="51.5005" gradientUnits="userSpaceOnUse">
                  <stop stop-color="#4793EB"/>
                  <stop offset="1" stop-color="#2367EC"/>
                </linearGradient>
                <linearGradient id="paint1_linear_4651_7043" x1="35.459" y1="50.5459" x2="35.459" y2="60.3946" gradientUnits="userSpaceOnUse">
                  <stop stop-color="#2B50D2"/>
                  <stop offset="1" stop-color="#182EA5"/>
                </linearGradient>
                <linearGradient id="paint2_linear_4651_7043" x1="36.2291" y1="21.742" x2="36.2291" y2="43.2976" gradientUnits="userSpaceOnUse">
                  <stop stop-color="white"/>
                  <stop offset="1" stop-color="#EDF1F2"/>
                </linearGradient>
                <radialGradient id="paint3_radial_4651_7043" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(53.3947 46.2927) scale(19.6317 19.6317)">
                  <stop stop-color="#FFB980"/>
                  <stop offset="1" stop-color="#F59815"/>
                </radialGradient>
                <radialGradient id="paint4_radial_4651_7043" cx="0" cy="0" r="1" gradientUnits="userSpaceOnUse" gradientTransform="translate(53.0218 48.7985) scale(17.5076 17.5076)">
                  <stop offset="0.061" stop-color="white"/>
                  <stop offset="1" stop-color="#F2EBE6"/>
                </radialGradient>
              </defs>
            </svg>
            <!-- <img class="pt-1" src="/assets/icon/uploa  d_video.png"> -->
            <form id="fileUploadForm" enctype="multipart/form-data">
                @csrf
                <input id="file-input" type="file" name="file" accept="video/*"  />
            </form>
            <i class="fas fa-video"></i>
          </label>
          <div id="preview-container"></div>
            <ion-card-title >Upload Your Workout Video</ion-card-title>
            <ion-card-subtitle class="pb-3">MP4, MOV</ion-card-subtitle>
            <div id="status"></div>
            <div id="progress-container">
                <progress id="uploadProgress" value="0" max="100"></progress>
                <span id="percentage">0%</span>
            </div>
        </ion-card>
        
        <ion-col size="12" class="p_tag"> <p>This is to track form correction in depth. You have to upload your video of selected primary movements which is based on exercises are done</p></ion-col>
       
      </ion-row>
      
    </ion-grid>
    <ion-footer class="ion-no-border ion-text-center" style="position: absolute;
    bottom: 0;">
        <ion-toolbar>
            <ion-button class="footer_btn " id="uploadBtn">Share</ion-button>
        </ion-toolbar>
    </ion-footer>
</ion-content>
<script>
   
    $(document).ready(function () {
        $('#progress-container').hide();
        $('#uploadBtn').on('click', function () {
            const fileInput = $('#file-input')[0].files;

            // Check if a file is selected
            if (fileInput.length === 0) {
            $('#status').text('No file selected. Please choose a file.');
            return;
            }

            // Prepare the file for uploading
            const formData = new FormData();
            formData.append('file', fileInput[0]);
            formData.append('_token', "{{csrf_token()}}");
            formData.append('user_id', "{{$user_id}}");
            formData.append('workout_id', "{{$workout_id}}");

            // AJAX call for file upload with progress tracking
            $.ajax({
            url: '{{route("save-form-builder-video")}}', // Replace with your server endpoint
            type: 'POST',
            data: formData,
            processData: false, // Prevent jQuery from processing the data
            contentType: false, // Prevent jQuery from overriding the content type
            xhr: function () {
                const xhr = $.ajaxSettings.xhr();
                xhr.upload.onprogress = function (event) {
                if (event.lengthComputable) {
                    $('#progress-container').show();
                    const percentage = Math.round((event.loaded / event.total) * 100);
                    $('#uploadProgress').val(percentage);
                    $('#percentage').text(percentage + '%');
                }
                };
                return xhr;
            },
            success: function (response) {
                $('#progress-container').hide();
                $('#status').text('File uploaded successfully!');
                console.log(response); // Handle server response
                window.open('{{route("success-form-builder-video")}}','_self')
            },
            error: function (error) {
                $('#status').text('Error uploading the file.');
                console.error(error); // Log errors
            }
            });
        });
        });


</script>
