<!DOCTYPE html>
<html lang="en">

<head>
    <title>Admin Users</title>
    <?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
<?php echo $__env->make('includes.flash-sms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                            <?php if(permission('admin_users','create')): ?> <button class="m-b-10 btn bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive">Add a New User</button><?php endif; ?>
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Admin Users</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Admin Users</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>First Name</th>
                                            <th>Email</th>
                                            <th>Role</th>
                                            <th>Status</th>
                                            <?php if(permission('admin_users','update') || permission('admin_users','delete')): ?>
                                            <th>Action</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($list->id); ?></td>
                                            <td><?php echo e($list->name); ?></td>
                                            <td><?php echo e($list->email); ?></td>
                                            <td>
                                                <?php if($list->role=='user'): ?><span class="badge bg-gradient-info">Trainer</span>
                                                <?php elseif($list->role=='admin'): ?><span class="badge bg-gradient-dark">Admin</span>
                                                <?php elseif($list->role=='subadmin'): ?><span class="badge bg-gradient-secondary">Sub Admin</span>
                                                <?php else: ?><span class="badge bg-gradient-secondary"><?php echo e($list->role); ?></span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php if($list->status==1): ?>
                                                    <span class="badge bg-gradient-success">Active</span>
                                                <?php elseif($list->status==0): ?>
                                                    <span class="badge bg-gradient-danger">Disabled</span>
                                                <?php endif; ?>
                                            </td>
                                            <?php if(permission('admin_users','update') || permission('admin_users','delete')): ?>
                                            <td>
                                                <?php if(permission('admin_users','update')): ?>
                                                    <?php if($list->role=='user' && permission('admin_users','trainee')): ?>
                                                        <a href="<?php echo e(route('assigned-users',['id'=>$list->id])); ?>">
                                                            <button class="btn btn-sm bg-gradient-dark" title="List Assigned Trainee"><i class="feather icon-list"></i></button>
                                                        </a>
                                                    <?php endif; ?>
                                                    <button class="btn btn-sm bg-gradient-info pr" data-toggle="modal" data-target="#exampleModalLive<?php echo e($list->id); ?>" title="Edit Details"><i class="feather icon-edit"></i></button>
                                                    <a href="<?php echo e(route('users-disable',['id'=>$list->id])); ?>" title="Enable/Disable Account" onclick="return confirm('Change Status?')">
                                                        <button class="btn btn-sm bg-gradient-secondary"><i class="feather icon-slash"></i></button>
                                                    </a>
                                                    <button class="btn btn-sm bg-gradient-warning" title="Change Password"><img height="18" width="15" onclick="changePassword(<?php echo e($list->id); ?>)" src="<?php echo e(asset('assets/cust-icons/key.svg')); ?>"></button>
                                                <?php endif; ?>
                                                <?php if(permission('admin_users','delete')): ?>
                                                    <a href="<?php echo e(route('app-users-delete',['id'=>$list->id])); ?>" title="Delete Account " onclick="return confirm('Are you sure? Delete User')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                <?php endif; ?>
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4"> Empty</td>
                                        </tr>
                                        <?php endif; ?>
                                        
                                    </tbody>
                                </table>
                                <?php echo e($user->links('pagination.simple')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    <?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <div id="exampleModalLive" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLiveLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
               
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLiveLabel">Add a New User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
           
                <div class="modal-body">
                
                    <form action="<?php echo e(route('store-admin-user')); ?>" id="storeUser" method="post">
                        <?php echo csrf_field(); ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="myname">Name <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="myname" id="myname" required placeholder="Enter name">
                                </div>
                                <div class="form-group">
                                    <label for="my_email">Email address <span class="text-danger">*</span></label>
                                    <input type="email" class="form-control" name="my_email" id="my_email" required aria-describedby="emailHelp" placeholder="Enter email">
                                </div>
                                <div class="form-group">
                                    <label for="password">Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="password" id="password" required placeholder="Password">
                                </div>
                                <div class="form-group">
                                    <label for="confirm_password">Confirm Password <span class="text-danger">*</span></label>
                                    <input type="password" class="form-control" name="confirm_password" id="confirm_password" required placeholder="Confirm Password">
                                    <span class="err-msg text-danger"></span>
                                </div>
                                
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Date of Birth <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control" max="<?php echo e(date('Y-m-d',strtotime('-1 year'))); ?>" name="dob" required>
                                </div>
                                <div class="form-group">
                                    <label for="userRole">Role <span class="text-danger">*</span></label>
                                    <select class="form-control" id="userRole" name="role" required>
                                        <option value="" selected disabled>Select Role</option>
                                        <?php $__currentLoopData = $role; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <option value="<?php echo e($list->name); ?>"><?php echo e($list->name=="user"?'User (Trainer)':$list->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <label for="exampleFormControlTextarea1">Mobile Number <span class="text-danger">*</span></label>
                                    <input type="tel" class="form-control" name="mobile_no" required placeholder="Mobile no.">
                                </div>
                            </div>
                        
                        </div>
                
                        <div class="modal-footer">
                            <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                            <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <?php $__empty_1 = true; $__currentLoopData = $user; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
    <div id="exampleModalLive<?php echo e($list->id); ?>" class="modal fade" tabindex="1" role="dialog" aria-labelledby="exampleModalLive<?php echo e($list->id); ?>Label" aria-hidden="true">
        <div class="modal-dialog" role="document1">
            <div class="modal-content">
               
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLive<?php echo e($list->id); ?>Label">Edit User</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                </div>
           
                <div class="modal-body">
                
                <form action="<?php echo e(route('update-admin-user')); ?>" id="storeUser<?php echo e($list->id); ?>" method="post">
                    <?php echo csrf_field(); ?>
                     <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="myname">Name <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="myname" value="<?php echo e($list->name); ?>" required placeholder="Enter name">
                                <input type="hidden" class="form-control" name="id"  value="<?php echo e($list->id); ?>" >
                            </div>
                            <div class="form-group">
                                <label for="my_email">Email address <span class="text-danger">*</span></label>
                                <input type="email" class="form-control" name="my_email" value="<?php echo e($list->email); ?>" required aria-describedby="emailHelp" placeholder="Enter email">
                            </div>
                            <div class="form-group">
                                <label for="exampleFormControlTextarea1">Mobile Number <span class="text-danger">*</span></label>
                                <input type="tel" class="form-control" value="<?php echo e($list->phone); ?>" name="mobile_no" required placeholder="Mobile no.">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Date of Birth <span class="text-danger">*</span></label>
                                <input type="date"  value="<?php echo e($list->dob); ?>" class="form-control" max="<?php echo e(date('Y-m-d',strtotime('-1 year'))); ?>" name="dob" required>
                            </div>
                            <div class="form-group">
                                <label for="userRole">Role <span class="text-danger">*</span></label>
                                <select class="form-control"  name="role" required>
                                    <option value="" selected disabled>Select Role</option>
                                    <?php $__currentLoopData = $role; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> 
                                    <option value="<?php echo e($slist->name); ?>"  <?php if($list->role==$slist->name): ?> selected <?php endif; ?> >
                                        <?php echo e($slist->name=="user"?'User (Trainer)':$slist->name); ?></option> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                        </div>
                    
                    </div>
              
                    <div class="modal-footer">
                        <button type="button" class="btn  bg-gradient-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn  bg-gradient-info pr">Submit</button>
                    </div>
                </form>
            </div>
        </div>
        </div>
    </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
  
    <script>

        function changePassword(id){
            Swal.fire({
                title: "Enter new password",
                input: "password",
                inputLabel: "New Password",
                inputPlaceholder: "Enter new password",
                inputAttributes: {
                    maxlength: "10",
                    autocapitalize: "off",
                    autocorrect: "off"
                },
                showCancelButton: true,
                confirmButtonText: "Submit",
                showLoaderOnConfirm: true,
                preConfirm: async (login) => {
                    if(login==""){
                        return Swal.showValidationMessage(`Enter Password`);
                    }
                    try {
                    const response = await fetch('<?php echo e(route("users-password")); ?>',{
                        headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                        },
                        method: "POST",
                        body: JSON.stringify({id:id,password:login,_token:$("input[name=_token]").val()})
                    });
                    if (!response.ok) {
                        return Swal.showValidationMessage(`
                        ${JSON.stringify(await response.json())}
                        `);
                    }
                    return response.json();
                    } catch (error) {
                    Swal.showValidationMessage(`
                        Request failed: ${error}
                    `);
                    
                    }
                },
                allowOutsideClick: () => !Swal.isLoading()
                }).then((result) => {
                if (result.isConfirmed) {
                    ToastK.fire({
                        icon: result.value.type ,
                        title: result.value.message 
                    });
                }
            });
        }
        $(document).on('submit','#storeUser',()=>{
            if($('input[name=password]').val()!=$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','red 1px solid');
                $('.err-msg').html('Recheck Passwords')
                return false;
            }
            $('#storeUser').submit();
        });
        $(document).on('input','input[name=password],input[name=confirm_password]',()=>{
            if($('input[name=password]').val()==$('input[name=confirm_password]').val()){
                $('input[name=password],input[name=confirm_password]').css('border','green 1px solid');
                $('.err-msg').html('')
            }
        });
    </script>
</body>

</html><?php /**PATH D:\xampp\htdocs\fitness-junction-main\ftj\resources\views/admin/users.blade.php ENDPATH**/ ?>