<!DOCTYPE html>
<html lang="en">

<head>
    <title>Requests Premium</title>
    <?php echo $__env->make('includes.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</head>
<body>
<?php echo $__env->make('includes.flash-sms', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.navbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('includes.topbar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <!-- [ Main Content ] start -->
    <div class="pcoded-main-container">
        <div class="pcoded-content">
            <!-- [ breadcrumb ] start -->
            <div class="page-header ">
                <div class="page-block">
                    <div class="row align-items-center">
                        <div class="col-md-12">
                            <div class="float-right">
                           
                            </div>
                            <ul class="breadcrumb">
                                <li class="breadcrumb-item"><a href="<?php echo e(route('dashboard')); ?>"><i class="feather icon-home"></i></a></li>
                                <li class="breadcrumb-item"><a >Requests Premium</a></li>
                            </ul>
                            
                        </div>
                    </div>
                </div>
            </div>
            <!-- [ breadcrumb ] end -->
   
            <!-- [ Main Content ] start -->
            <div class="row">
                <!-- [ stiped-table ] start -->
                <div class="col-xl-12">
                    <div class="card">
                        <div class="card-header">
                            <h5>Requests Premium</h5>
                        </div>
                        <div class="card-body table-border-style">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>User</th>
                                            <th>Current Plan</th>
                                            <th>Requested For Plan</th>
                                            <th>Requested On</th>
                                            <th>Status</th>
                                            <?php if(permission('request_premium','update') || permission('request_premium','delete')): ?>
                                            <th>Action</th>
                                            <?php endif; ?>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__empty_1 = true; $__currentLoopData = $listing; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $list): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($list->id); ?></td>
                                            <td><?php echo e($list->user->name); ?>

                                                <a target="_blank" href="<?php echo e(route('app-users-sts',['id'=>$list->user->id])); ?>"><span class="btn btn-sm bg-gradient-dark"><i class="feather icon-external-link"></i></span></a><br>
                                                <a href="tel:<?php echo e($list->user->phone); ?>"> <span class="btn btn-sm bg-gradient-warning"><i class="feather icon-phone"></i></span></a>
                                                <a href="mailto:<?php echo e($list->user->email); ?>"><span class="btn btn-sm bg-gradient-success"><i class="feather icon-mail"></i></span></a>
                                            </td>
                                            <td style="background:#e2e2e2">Plan: 
                                                <?php if(!empty($list->current_plan->name)): ?>
                                                    <?php echo e($list->current_plan->name); ?><br>
                                                    Duration: <?php echo e($list->current_plan->duration); ?><br>
                                                    Price: <?php if($list->current_plan->amount>0): ?><span class="badge bg-gradient-warning">&#8377; <?php echo e($list->current_plan->amount); ?></span> <?php else: ?> <span class="badge bg-gradient-success">Free</span> <?php endif; ?> <br>
                                                    Final Price :<?php if($list->current_plan->final_price>0): ?><span class="badge bg-gradient-info">&#8377; <?php echo e($list->current_plan->final_price); ?></span> <?php else: ?> <span class="badge bg-gradient-success">Free</span> <?php endif; ?> <br>
                                                    Discount <?php if($list->current_plan->discount>0): ?><span class="badge bg-gradient-info pr"><?php echo e($list->current_plan->discount); ?>%</span> <?php endif; ?> 
                                                    <?php if($list->current_plan->amount>0): ?><br> Expiry : <?php echo e(date('d M Y',strtotime((json_decode($list->user->gateway_ref)->end)??''))); ?> <?php endif; ?>
                                                <?php else: ?>
                                                <span class="badge bg-gradient-success">Free</span>
                                                <?php endif; ?>
                                            </td>
                                            <td style="background:#b4ddc5">Plan: 
                                                <?php if(!empty($list->plan->name)): ?> <?php echo e($list->plan->name); ?><br>
                                                    Duration: <?php echo e($list->plan->duration); ?><br>
                                                    Price: <?php if($list->plan->amount>0): ?><span class="badge bg-gradient-warning">&#8377; <?php echo e($list->plan->amount); ?></span> <?php else: ?> <span class="badge bg-gradient-success">Free</span> <?php endif; ?> <br>
                                                    Final Price :<?php if($list->plan->final_price>0): ?><span class="badge bg-gradient-info">&#8377; <?php echo e($list->plan->final_price); ?></span> <?php else: ?> <span class="badge bg-gradient-success">Free</span> <?php endif; ?> <br>
                                                    Discount <?php if($list->plan->discount>0): ?><span class="badge bg-gradient-info pr"><?php echo e($list->plan->discount); ?>%</span> <?php endif; ?>
                                                <?php else: ?>
                                                <span class="badge bg-gradient-success">Free</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e(date('d M Y',strtotime($list->created_at))); ?></td>
                                            <td><?php if($list->status==0): ?>
                                                    <span class="badge bg-gradient-secondary">Draft</span>
                                                <?php elseif($list->status==1): ?>
                                                    <span class="badge bg-gradient-warning">Call Pending</span>
                                                <?php elseif($list->status==2): ?>
                                                    <span class="badge bg-gradient-info pr">Payment Pending</span>
                                                <?php elseif($list->status==3): ?>
                                                    <span class="badge bg-gradient-success">Plan Activated</span>
                                                <?php endif; ?>
                                                <?php if(!empty($list->last_update)): ?>
                                                    <br>
                                                    Last Update: <?php echo e($list->last_update->name); ?><br>
                                                    Role: <?php echo e($list->last_update->role); ?><br>
                                                    Email: <?php echo e(substr_replace($list->last_update->email, str_repeat('*', strlen($list->last_update->email)-8), 2, -8)); ?>

                                                <?php endif; ?>
                                            </td>
                                            <?php if(permission('request_premium','update') || permission('request_premium','delete')): ?>
                                            <td>
                                                <?php if(permission('request_premium','update')): ?>
                                                    <button class="btn btn-sm bg-gradient-dark" onclick="changeStatus('<?php echo e($list->id); ?>')" ><i class="feather icon-refresh-cw"></i>  Status</button>
                                                <?php endif; ?>
                                                <!-- <?php if(permission('request_premium','delete')): ?>
                                                    <a href="<?php echo e(route('app-users-delete',['id'=>$list->id])); ?>" title="Delete Account " onclick="return confirm('Are you sure? Delete User')">
                                                        <button class="btn btn-sm bg-gradient-danger"><i class="feather icon-trash-2"></i></button>
                                                    </a>
                                                <?php endif; ?> -->
                                            </td>
                                            <?php endif; ?>
                                        </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td <?php if(permission('request_premium','update') || permission('request_premium','delete')): ?> colspan="6" <?php else: ?> colspan="6" <?php endif; ?> class="text-center">No Requests</td>
                                        </tr>
                                        <?php endif; ?>
                                        
                                    </tbody>
                                </table>
                                <?php echo e($listinga->links('pagination.simple')); ?>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- [ stiped-table ] end -->
            </div>
            <!-- [ Main Content ] end -->
             
        </div>
    </div>
    <?php echo $__env->make('includes.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

 
    <!-- Apex Chart -->
    <script src="<?php echo e(asset('assets/js/plugins/apexcharts.min.js')); ?>"></script>
    <!-- custom-chart js -->
    <script src="<?php echo e(asset('assets/js/pages/dashboard-main.js')); ?>"></script>
    <script>

        function changeStatus(myid){
            Swal.fire({
            title: "Change Status",
            input: "select",
            inputOptions: {
                draft: "Draft",
                call_pending: "Call Pending",
                payment_pending: "Payment Pending",
                plan_activated: "Plan Activated",
            },
            inputPlaceholder: "Select a status",
            showCancelButton: true,
            confirmButtonText: "Save",
            showLoaderOnConfirm: true,
            preConfirm: async (login) => {
                try {
                    if(login==""){
                        return Swal.showValidationMessage(`Select Status`);
                    }
                    const response = await fetch('<?php echo e(route("status-request-premium")); ?>',{
                        headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                        },
                        method: "POST",
                        body: JSON.stringify({id:myid,status:login,_token:"<?php echo e(csrf_token()); ?>"})
                    });
                    if (!response.ok) {
                        let jsv = await response.json();
                       
                        return Swal.showValidationMessage(jsv.message);
                    } 
                    return response.json();
                } catch (error) {
                    console.log(error)
                    Swal.showValidationMessage(`
                        Request failed: ${error}
                    `);
                }
            },
            allowOutsideClick: () => !Swal.isLoading()
            }).then((result) => {
                console.log(result)
            if (result.isConfirmed) {
                Swal.fire({
                    position: "top-end",
                    icon: "success",
                    title: "Status Updated",
                    showConfirmButton: false,
                    timer: 1500
                }).then(()=>{
                    window.location.reload();
                });
            }
            });
           
        }
       
    </script>
</body>

</html><?php /**PATH D:\xampp\htdocs\fitness-junction-main\ftj\resources\views/admin/request-pro/pro.blade.php ENDPATH**/ ?>