
import type { Deal, DealStatus } from './types';

const STATUSES: DealStatus[] = ['NEW', 'CHAT', 'PAPERS', 'SIGNING', 'PROGRESS', 'DOCUMENT'];
const NAMES = ['AVNEET KAUR', 'Maria Davis', 'Kate Willson', 'John Doe', 'Emily Walker', 'Michael Scott', 'Dwight Schrute', 'Jim Halpert', 'Pam Beesly', 'Ryan Howard', 'Kelly Kapoor', 'Andy Bernard', 'Angela Martin', 'Kevin Malone', 'Oscar Martinez', 'Stanley Hudson', 'Phyllis Vance', 'Toby Flenderson', 'Creed Bratton', 'Meredith Palmer'];
const TITLES = ['MGM (call unanswered)', 'Online store order', 'Inquiry regarding services', 'Follow up meeting', 'Contract review', 'New lead from website', 'Quote request', 'Demo scheduled', 'Payment pending', 'Document verification'];
const TYPES = ['individual', 'business'];
const TASK_STATUSES = ['FINISHED', 'IN PROGRESS', 'PENDING'];

const generateDeals = (count: number): Deal[] => {
  const deals: Deal[] = [];
  for (let i = 1; i <= count; i++) {
    const status = STATUSES[Math.floor(Math.random() * STATUSES.length)];
    const contactName = NAMES[Math.floor(Math.random() * NAMES.length)];
    const title = `${contactName} ${TITLES[Math.floor(Math.random() * TITLES.length)]} #${i}`;
    const amount = Math.floor(Math.random() * 10000);
    const currency = Math.random() > 0.5 ? '₹' : '$';
    const type = TYPES[Math.floor(Math.random() * TYPES.length)];
    const taskStatus = TASK_STATUSES[Math.floor(Math.random() * TASK_STATUSES.length)];
    const dateText = i <= 3 ? 'just now' : 'September 21, 2024';

    deals.push({
      id: `${i}`,
      title,
      amount,
      currency,
      contactName,
      type,
      dateText,
      modifiedDate: '02.09.2025 10:59:20 am',
      taskStatus,
      responsiblePerson: NAMES[Math.floor(Math.random() * NAMES.length)],
      status,
      activityCount: Math.floor(Math.random() * 10),
      hasPhone: Math.random() > 0.2,
      hasEmail: Math.random() > 0.2,
      hasChat: Math.random() > 0.2,
      isRepeat: Math.random() > 0.8
    });
  }
  return deals;
};

export const INITIAL_DEALS: Deal[] = generateDeals(500);

export const COLUMNS: { id: DealStatus; title: string; color: string; textColor: string }[] = [
  { id: 'NEW', title: 'New', color: '#44d8f2', textColor: '#004a54' },
  { id: 'CHAT', title: 'Processing in chat', color: '#47ced2', textColor: '#003d3f' },
  { id: 'PAPERS', title: 'Create papers', color: '#c3e532', textColor: '#3d4a00' },
  { id: 'SIGNING', title: 'Contract signing', color: '#59d2e8', textColor: '#00424d' },
  { id: 'PROGRESS', title: 'In progress', color: '#32c19e', textColor: '#003a2f' },
  { id: 'DOCUMENT', title: "Document Checking", color: '#c3e532', textColor: '#003a2f' }
];
