<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Pollen;

class LookupForecastResponse extends \Google\Collection
{
  protected $collection_key = 'dailyInfo';
  protected $dailyInfoType = DayInfo::class;
  protected $dailyInfoDataType = 'array';
  /**
   * Optional. The token to retrieve the next page.
   *
   * @var string
   */
  public $nextPageToken;
  /**
   * The ISO_3166-1 alpha-2 code of the country/region corresponding to the
   * location provided in the request. This field might be omitted from the
   * response if the location provided in the request resides in a disputed
   * territory.
   *
   * @var string
   */
  public $regionCode;

  /**
   * Required. This object contains the daily forecast information for each day
   * requested.
   *
   * @param DayInfo[] $dailyInfo
   */
  public function setDailyInfo($dailyInfo)
  {
    $this->dailyInfo = $dailyInfo;
  }
  /**
   * @return DayInfo[]
   */
  public function getDailyInfo()
  {
    return $this->dailyInfo;
  }
  /**
   * Optional. The token to retrieve the next page.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * The ISO_3166-1 alpha-2 code of the country/region corresponding to the
   * location provided in the request. This field might be omitted from the
   * response if the location provided in the request resides in a disputed
   * territory.
   *
   * @param string $regionCode
   */
  public function setRegionCode($regionCode)
  {
    $this->regionCode = $regionCode;
  }
  /**
   * @return string
   */
  public function getRegionCode()
  {
    return $this->regionCode;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LookupForecastResponse::class, 'Google_Service_Pollen_LookupForecastResponse');
